"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudfrontWebAcl = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
/**
 * This construct creates a WAFv2 Web ACL for cloudfront in the us-east-1 region (required for cloudfront) no matter the
 * region of the parent cdk stack.
 */
class CloudfrontWebAcl extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const onEventHandler = new aws_lambda_1.Function(this, "CloudfrontWebAclOnEventHandler", {
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, "../lib/webacl_event_handler")),
            functionName: "CloudfrontWebAclCustomResource",
            handler: "index.onEvent",
            runtime: aws_lambda_1.Runtime.NODEJS_16_X,
            timeout: aws_cdk_lib_1.Duration.seconds(300),
        });
        onEventHandler.role.addToPrincipalPolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: [
                "wafv2:CreateWebACL",
                "wafv2:DeleteWebACL",
                "wafv2:UpdateWebACL",
                "wafv2:GetWebACL",
                "wafv2:CreateIPSet",
                "wafv2:DeleteIPSet",
                "wafv2:UpdateIPSet",
                "wafv2:GetIPSet",
            ],
            resources: ["*"],
        }));
        const provider = new custom_resources_1.Provider(this, "CloudfrontWebAclProvider", {
            onEventHandler,
        });
        const customResource = new aws_cdk_lib_1.CustomResource(this, "CFWebAclCustomResource", {
            serviceToken: provider.serviceToken,
            properties: {
                ID: id,
                MANAGED_RULES: props?.managedRules ?? [
                    { vendor: "AWS", name: "AWSManagedRulesCommonRuleSet" },
                ],
                CIDR_ALLOW_LIST: props?.cidrAllowList,
            },
        });
        this.webAclId = customResource.getAttString("WebAclId");
        this.webAclArn = customResource.getAttString("WebAclArn");
    }
}
exports.CloudfrontWebAcl = CloudfrontWebAcl;
_a = JSII_RTTI_SYMBOL_1;
CloudfrontWebAcl[_a] = { fqn: "@aws-prototyping-sdk/static-website.CloudfrontWebAcl", version: "0.2.15" };
//# sourceMappingURL=data:application/json;base64,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