import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataIonoscloudTemplateConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/template#cores DataIonoscloudTemplate#cores}
    */
    readonly cores?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/template#name DataIonoscloudTemplate#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/template#ram DataIonoscloudTemplate#ram}
    */
    readonly ram?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/template#storage_size DataIonoscloudTemplate#storage_size}
    */
    readonly storageSize?: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/template#timeouts DataIonoscloudTemplate#timeouts}
    */
    readonly timeouts?: DataIonoscloudTemplateTimeouts;
}
export interface DataIonoscloudTemplateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/template#create DataIonoscloudTemplate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/template#default DataIonoscloudTemplate#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/template#delete DataIonoscloudTemplate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/d/template#update DataIonoscloudTemplate#update}
    */
    readonly update?: string;
}
export declare function dataIonoscloudTemplateTimeoutsToTerraform(struct?: DataIonoscloudTemplateTimeoutsOutputReference | DataIonoscloudTemplateTimeouts | cdktf.IResolvable): any;
export declare class DataIonoscloudTemplateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataIonoscloudTemplateTimeouts | undefined;
    set internalValue(value: DataIonoscloudTemplateTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/d/template ionoscloud_template}
*/
export declare class DataIonoscloudTemplate extends cdktf.TerraformDataSource {
    static readonly tfResourceType = "ionoscloud_template";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/d/template ionoscloud_template} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataIonoscloudTemplateConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataIonoscloudTemplateConfig);
    private _cores?;
    get cores(): number;
    set cores(value: number);
    resetCores(): void;
    get coresInput(): number | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _ram?;
    get ram(): number;
    set ram(value: number);
    resetRam(): void;
    get ramInput(): number | undefined;
    private _storageSize?;
    get storageSize(): number;
    set storageSize(value: number);
    resetStorageSize(): void;
    get storageSizeInput(): number | undefined;
    private _timeouts;
    get timeouts(): DataIonoscloudTemplateTimeoutsOutputReference;
    putTimeouts(value: DataIonoscloudTemplateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataIonoscloudTemplateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=data-ionoscloud-template.d.ts.map