import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DatacenterConfig extends cdktf.TerraformMetaArguments {
    /**
    * A description for the datacenter, e.g. staging, production
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/datacenter#description Datacenter#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/datacenter#location Datacenter#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/datacenter#name Datacenter#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/datacenter#sec_auth_protection Datacenter#sec_auth_protection}
    */
    readonly secAuthProtection?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/datacenter#timeouts Datacenter#timeouts}
    */
    readonly timeouts?: DatacenterTimeouts;
}
export interface DatacenterCpuArchitecture {
}
export declare function datacenterCpuArchitectureToTerraform(struct?: DatacenterCpuArchitecture): any;
export declare class DatacenterCpuArchitectureOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DatacenterCpuArchitecture | undefined;
    set internalValue(value: DatacenterCpuArchitecture | undefined);
    get cpuFamily(): string;
    get maxCores(): number;
    get maxRam(): number;
    get vendor(): string;
}
export declare class DatacenterCpuArchitectureList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DatacenterCpuArchitectureOutputReference;
}
export interface DatacenterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/datacenter#create Datacenter#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/datacenter#default Datacenter#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/datacenter#delete Datacenter#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/datacenter#update Datacenter#update}
    */
    readonly update?: string;
}
export declare function datacenterTimeoutsToTerraform(struct?: DatacenterTimeoutsOutputReference | DatacenterTimeouts | cdktf.IResolvable): any;
export declare class DatacenterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DatacenterTimeouts | undefined;
    set internalValue(value: DatacenterTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/datacenter ionoscloud_datacenter}
*/
export declare class Datacenter extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_datacenter";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/datacenter ionoscloud_datacenter} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DatacenterConfig
    */
    constructor(scope: Construct, id: string, config: DatacenterConfig);
    private _cpuArchitecture;
    get cpuArchitecture(): DatacenterCpuArchitectureList;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get features(): string[];
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _secAuthProtection?;
    get secAuthProtection(): boolean | cdktf.IResolvable;
    set secAuthProtection(value: boolean | cdktf.IResolvable);
    resetSecAuthProtection(): void;
    get secAuthProtectionInput(): boolean | cdktf.IResolvable | undefined;
    get version(): number;
    private _timeouts;
    get timeouts(): DatacenterTimeoutsOutputReference;
    putTimeouts(value: DatacenterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DatacenterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=datacenter.d.ts.map