import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface GroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#access_activity_log Group#access_activity_log}
    */
    readonly accessActivityLog?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#access_and_manage_certificates Group#access_and_manage_certificates}
    */
    readonly accessAndManageCertificates?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#access_and_manage_monitoring Group#access_and_manage_monitoring}
    */
    readonly accessAndManageMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#create_backup_unit Group#create_backup_unit}
    */
    readonly createBackupUnit?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#create_datacenter Group#create_datacenter}
    */
    readonly createDatacenter?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#create_flow_log Group#create_flow_log}
    */
    readonly createFlowLog?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#create_internet_access Group#create_internet_access}
    */
    readonly createInternetAccess?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#create_k8s_cluster Group#create_k8s_cluster}
    */
    readonly createK8SCluster?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#create_pcc Group#create_pcc}
    */
    readonly createPcc?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#create_snapshot Group#create_snapshot}
    */
    readonly createSnapshot?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#name Group#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#reserve_ip Group#reserve_ip}
    */
    readonly reserveIp?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#s3_privilege Group#s3_privilege}
    */
    readonly s3Privilege?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#user_id Group#user_id}
    */
    readonly userId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#user_ids Group#user_ids}
    */
    readonly userIds?: string[];
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#timeouts Group#timeouts}
    */
    readonly timeouts?: GroupTimeouts;
}
export interface GroupUsers {
}
export declare function groupUsersToTerraform(struct?: GroupUsers): any;
export declare class GroupUsersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): GroupUsers | undefined;
    set internalValue(value: GroupUsers | undefined);
    get administrator(): cdktf.IResolvable;
    get email(): string;
    get firstName(): string;
    get forceSecAuth(): cdktf.IResolvable;
    get id(): string;
    get lastName(): string;
    get password(): string;
}
export declare class GroupUsersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): GroupUsersOutputReference;
}
export interface GroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#create Group#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#default Group#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#delete Group#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/group#update Group#update}
    */
    readonly update?: string;
}
export declare function groupTimeoutsToTerraform(struct?: GroupTimeoutsOutputReference | GroupTimeouts | cdktf.IResolvable): any;
export declare class GroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): GroupTimeouts | undefined;
    set internalValue(value: GroupTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/group ionoscloud_group}
*/
export declare class Group extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_group";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/group ionoscloud_group} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options GroupConfig
    */
    constructor(scope: Construct, id: string, config: GroupConfig);
    private _accessActivityLog?;
    get accessActivityLog(): boolean | cdktf.IResolvable;
    set accessActivityLog(value: boolean | cdktf.IResolvable);
    resetAccessActivityLog(): void;
    get accessActivityLogInput(): boolean | cdktf.IResolvable | undefined;
    private _accessAndManageCertificates?;
    get accessAndManageCertificates(): boolean | cdktf.IResolvable;
    set accessAndManageCertificates(value: boolean | cdktf.IResolvable);
    resetAccessAndManageCertificates(): void;
    get accessAndManageCertificatesInput(): boolean | cdktf.IResolvable | undefined;
    private _accessAndManageMonitoring?;
    get accessAndManageMonitoring(): boolean | cdktf.IResolvable;
    set accessAndManageMonitoring(value: boolean | cdktf.IResolvable);
    resetAccessAndManageMonitoring(): void;
    get accessAndManageMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _createBackupUnit?;
    get createBackupUnit(): boolean | cdktf.IResolvable;
    set createBackupUnit(value: boolean | cdktf.IResolvable);
    resetCreateBackupUnit(): void;
    get createBackupUnitInput(): boolean | cdktf.IResolvable | undefined;
    private _createDatacenter?;
    get createDatacenter(): boolean | cdktf.IResolvable;
    set createDatacenter(value: boolean | cdktf.IResolvable);
    resetCreateDatacenter(): void;
    get createDatacenterInput(): boolean | cdktf.IResolvable | undefined;
    private _createFlowLog?;
    get createFlowLog(): boolean | cdktf.IResolvable;
    set createFlowLog(value: boolean | cdktf.IResolvable);
    resetCreateFlowLog(): void;
    get createFlowLogInput(): boolean | cdktf.IResolvable | undefined;
    private _createInternetAccess?;
    get createInternetAccess(): boolean | cdktf.IResolvable;
    set createInternetAccess(value: boolean | cdktf.IResolvable);
    resetCreateInternetAccess(): void;
    get createInternetAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _createK8SCluster?;
    get createK8SCluster(): boolean | cdktf.IResolvable;
    set createK8SCluster(value: boolean | cdktf.IResolvable);
    resetCreateK8SCluster(): void;
    get createK8SClusterInput(): boolean | cdktf.IResolvable | undefined;
    private _createPcc?;
    get createPcc(): boolean | cdktf.IResolvable;
    set createPcc(value: boolean | cdktf.IResolvable);
    resetCreatePcc(): void;
    get createPccInput(): boolean | cdktf.IResolvable | undefined;
    private _createSnapshot?;
    get createSnapshot(): boolean | cdktf.IResolvable;
    set createSnapshot(value: boolean | cdktf.IResolvable);
    resetCreateSnapshot(): void;
    get createSnapshotInput(): boolean | cdktf.IResolvable | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _reserveIp?;
    get reserveIp(): boolean | cdktf.IResolvable;
    set reserveIp(value: boolean | cdktf.IResolvable);
    resetReserveIp(): void;
    get reserveIpInput(): boolean | cdktf.IResolvable | undefined;
    private _s3Privilege?;
    get s3Privilege(): boolean | cdktf.IResolvable;
    set s3Privilege(value: boolean | cdktf.IResolvable);
    resetS3Privilege(): void;
    get s3PrivilegeInput(): boolean | cdktf.IResolvable | undefined;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    resetUserId(): void;
    get userIdInput(): string | undefined;
    private _userIds?;
    get userIds(): string[];
    set userIds(value: string[]);
    resetUserIds(): void;
    get userIdsInput(): string[] | undefined;
    private _users;
    get users(): GroupUsersList;
    private _timeouts;
    get timeouts(): GroupTimeoutsOutputReference;
    putTimeouts(value: GroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): GroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=group.d.ts.map