import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface NetworkloadbalancerForwardingruleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Algorithm for the balancing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#algorithm NetworkloadbalancerForwardingrule#algorithm}
    */
    readonly algorithm: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#datacenter_id NetworkloadbalancerForwardingrule#datacenter_id}
    */
    readonly datacenterId: string;
    /**
    * Listening IP. (inbound)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#listener_ip NetworkloadbalancerForwardingrule#listener_ip}
    */
    readonly listenerIp: string;
    /**
    * Listening port number. (inbound) (range: 1 to 65535)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#listener_port NetworkloadbalancerForwardingrule#listener_port}
    */
    readonly listenerPort: number;
    /**
    * A name of that Network Load Balancer forwarding rule
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#name NetworkloadbalancerForwardingrule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#networkloadbalancer_id NetworkloadbalancerForwardingrule#networkloadbalancer_id}
    */
    readonly networkloadbalancerId: string;
    /**
    * Protocol of the balancing.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#protocol NetworkloadbalancerForwardingrule#protocol}
    */
    readonly protocol: string;
    /**
    * health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#health_check NetworkloadbalancerForwardingrule#health_check}
    */
    readonly healthCheck?: NetworkloadbalancerForwardingruleHealthCheck;
    /**
    * targets block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#targets NetworkloadbalancerForwardingrule#targets}
    */
    readonly targets: NetworkloadbalancerForwardingruleTargets[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#timeouts NetworkloadbalancerForwardingrule#timeouts}
    */
    readonly timeouts?: NetworkloadbalancerForwardingruleTimeouts;
}
export interface NetworkloadbalancerForwardingruleHealthCheck {
    /**
    * ClientTimeout is expressed in milliseconds. This inactivity timeout applies when the client is expected to acknowledge or send data. If unset the default of 50 seconds will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#client_timeout NetworkloadbalancerForwardingrule#client_timeout}
    */
    readonly clientTimeout?: number;
    /**
    * It specifies the maximum time (in milliseconds) to wait for a connection attempt to a target VM to succeed. If unset, the default of 5 seconds will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#connect_timeout NetworkloadbalancerForwardingrule#connect_timeout}
    */
    readonly connectTimeout?: number;
    /**
    * Retries specifies the number of retries to perform on a target VM after a connection failure. If unset, the default value of 3 will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#retries NetworkloadbalancerForwardingrule#retries}
    */
    readonly retries?: number;
    /**
    * TargetTimeout specifies the maximum inactivity time (in milliseconds) on the target VM side. If unset, the default of 50 seconds will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#target_timeout NetworkloadbalancerForwardingrule#target_timeout}
    */
    readonly targetTimeout?: number;
}
export declare function networkloadbalancerForwardingruleHealthCheckToTerraform(struct?: NetworkloadbalancerForwardingruleHealthCheckOutputReference | NetworkloadbalancerForwardingruleHealthCheck): any;
export declare class NetworkloadbalancerForwardingruleHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkloadbalancerForwardingruleHealthCheck | undefined;
    set internalValue(value: NetworkloadbalancerForwardingruleHealthCheck | undefined);
    private _clientTimeout?;
    get clientTimeout(): number;
    set clientTimeout(value: number);
    resetClientTimeout(): void;
    get clientTimeoutInput(): number | undefined;
    private _connectTimeout?;
    get connectTimeout(): number;
    set connectTimeout(value: number);
    resetConnectTimeout(): void;
    get connectTimeoutInput(): number | undefined;
    private _retries?;
    get retries(): number;
    set retries(value: number);
    resetRetries(): void;
    get retriesInput(): number | undefined;
    private _targetTimeout?;
    get targetTimeout(): number;
    set targetTimeout(value: number);
    resetTargetTimeout(): void;
    get targetTimeoutInput(): number | undefined;
}
export interface NetworkloadbalancerForwardingruleTargetsHealthCheck {
    /**
    * Check specifies whether the target VM's health is checked.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#check NetworkloadbalancerForwardingrule#check}
    */
    readonly check?: boolean | cdktf.IResolvable;
    /**
    * CheckInterval determines the duration (in milliseconds) between consecutive health checks. If unspecified a default of 2000 ms is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#check_interval NetworkloadbalancerForwardingrule#check_interval}
    */
    readonly checkInterval?: number;
    /**
    * Maintenance specifies if a target VM should be marked as down, even if it is not.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#maintenance NetworkloadbalancerForwardingrule#maintenance}
    */
    readonly maintenance?: boolean | cdktf.IResolvable;
}
export declare function networkloadbalancerForwardingruleTargetsHealthCheckToTerraform(struct?: NetworkloadbalancerForwardingruleTargetsHealthCheckOutputReference | NetworkloadbalancerForwardingruleTargetsHealthCheck): any;
export declare class NetworkloadbalancerForwardingruleTargetsHealthCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkloadbalancerForwardingruleTargetsHealthCheck | undefined;
    set internalValue(value: NetworkloadbalancerForwardingruleTargetsHealthCheck | undefined);
    private _check?;
    get check(): boolean | cdktf.IResolvable;
    set check(value: boolean | cdktf.IResolvable);
    resetCheck(): void;
    get checkInput(): boolean | cdktf.IResolvable | undefined;
    private _checkInterval?;
    get checkInterval(): number;
    set checkInterval(value: number);
    resetCheckInterval(): void;
    get checkIntervalInput(): number | undefined;
    private _maintenance?;
    get maintenance(): boolean | cdktf.IResolvable;
    set maintenance(value: boolean | cdktf.IResolvable);
    resetMaintenance(): void;
    get maintenanceInput(): boolean | cdktf.IResolvable | undefined;
}
export interface NetworkloadbalancerForwardingruleTargets {
    /**
    * IP of a balanced target VM
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#ip NetworkloadbalancerForwardingrule#ip}
    */
    readonly ip: string;
    /**
    * Port of the balanced target service. (range: 1 to 65535)
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#port NetworkloadbalancerForwardingrule#port}
    */
    readonly port: number;
    /**
    * Weight parameter is used to adjust the target VM's weight relative to other target VMs
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#weight NetworkloadbalancerForwardingrule#weight}
    */
    readonly weight: number;
    /**
    * health_check block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#health_check NetworkloadbalancerForwardingrule#health_check}
    */
    readonly healthCheck?: NetworkloadbalancerForwardingruleTargetsHealthCheck;
}
export declare function networkloadbalancerForwardingruleTargetsToTerraform(struct?: NetworkloadbalancerForwardingruleTargets | cdktf.IResolvable): any;
export interface NetworkloadbalancerForwardingruleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#create NetworkloadbalancerForwardingrule#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#default NetworkloadbalancerForwardingrule#default}
    */
    readonly default?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#delete NetworkloadbalancerForwardingrule#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule#update NetworkloadbalancerForwardingrule#update}
    */
    readonly update?: string;
}
export declare function networkloadbalancerForwardingruleTimeoutsToTerraform(struct?: NetworkloadbalancerForwardingruleTimeoutsOutputReference | NetworkloadbalancerForwardingruleTimeouts | cdktf.IResolvable): any;
export declare class NetworkloadbalancerForwardingruleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): NetworkloadbalancerForwardingruleTimeouts | undefined;
    set internalValue(value: NetworkloadbalancerForwardingruleTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _default?;
    get default(): string;
    set default(value: string);
    resetDefault(): void;
    get defaultInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule ionoscloud_networkloadbalancer_forwardingrule}
*/
export declare class NetworkloadbalancerForwardingrule extends cdktf.TerraformResource {
    static readonly tfResourceType = "ionoscloud_networkloadbalancer_forwardingrule";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/ionoscloud/r/networkloadbalancer_forwardingrule ionoscloud_networkloadbalancer_forwardingrule} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NetworkloadbalancerForwardingruleConfig
    */
    constructor(scope: Construct, id: string, config: NetworkloadbalancerForwardingruleConfig);
    private _algorithm?;
    get algorithm(): string;
    set algorithm(value: string);
    get algorithmInput(): string | undefined;
    private _datacenterId?;
    get datacenterId(): string;
    set datacenterId(value: string);
    get datacenterIdInput(): string | undefined;
    get id(): string;
    private _listenerIp?;
    get listenerIp(): string;
    set listenerIp(value: string);
    get listenerIpInput(): string | undefined;
    private _listenerPort?;
    get listenerPort(): number;
    set listenerPort(value: number);
    get listenerPortInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkloadbalancerId?;
    get networkloadbalancerId(): string;
    set networkloadbalancerId(value: string);
    get networkloadbalancerIdInput(): string | undefined;
    private _protocol?;
    get protocol(): string;
    set protocol(value: string);
    get protocolInput(): string | undefined;
    private _healthCheck;
    get healthCheck(): NetworkloadbalancerForwardingruleHealthCheckOutputReference;
    putHealthCheck(value: NetworkloadbalancerForwardingruleHealthCheck): void;
    resetHealthCheck(): void;
    get healthCheckInput(): NetworkloadbalancerForwardingruleHealthCheck | undefined;
    private _targets?;
    get targets(): NetworkloadbalancerForwardingruleTargets[] | cdktf.IResolvable;
    set targets(value: NetworkloadbalancerForwardingruleTargets[] | cdktf.IResolvable);
    get targetsInput(): cdktf.IResolvable | NetworkloadbalancerForwardingruleTargets[] | undefined;
    private _timeouts;
    get timeouts(): NetworkloadbalancerForwardingruleTimeoutsOutputReference;
    putTimeouts(value: NetworkloadbalancerForwardingruleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): NetworkloadbalancerForwardingruleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
//# sourceMappingURL=networkloadbalancer-forwardingrule.d.ts.map