# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/format.ipynb (unless otherwise specified).

__all__ = ['journal2table', 'value_text_string', 'check_update', 'view_string']

# Cell
import json
from typing import Iterable
from fastcore.basics import listify

from .constants import TABLECOLS, FIELD2ID
from tabulate import tabulate

# Cell
def journal2table(journal):
    """Recebe a string journal, caso a formatação seja compatível com um csv, retorna este formato como markdown
    Do contrário simplesmente retorna a string inalterada"""
    try:
        string = json.loads(journal)
        string = listify(string)
        headers = [TABLECOLS.get(s, s) for s in string[0].keys()]
        values = [list(d.values()) for d in string]
    except json.JSONDecodeError:
        table = [
            [r.strip() for r in j.strip().split(",")]
            for j in journal.split("\n")
            if j.strip() != ""
        ]
        if len({len(t) for t in table}) != 1:
            print(
                "O texto passado como notes, não está configurado corretamente para formatar uma tabela"
            )
            print(
                "No Campo notes será enviada a string no formato que está, sem modificação"
            )
            return journal
        values = table[1:]
        headers = table[0]

    return tabulate(values, headers, tablefmt="textile")


def value_text_string(input_value):
    """Formata `input_value` como string json contendo chaves `texto` e `valor` com o mesmo valor de `input_value`"""
    return "{" + '"valor":"{0}","texto":"{0}"'.format(input_value) + "}"



def check_update(
    field: str, value, dtype, values_set: Iterable = None, format: bool = False
) -> dict:
    """Checa se o valor `value` do campo `field` está dentro das atribuições definidas no
    dicionário DICT_FIELD[`field`]
    Returns: Dicionário no formato compatível com a API do Redmine {"id" : ... , "value" : ...}
    """
    if not isinstance(value, dtype):
        raise TypeError(
            f"É esperado que o campo {field} seja do tipo {dtype}, o fornecido foi {type(value)}"
        )

    if values_set and not set(listify(value)).issubset(set(values_set)):
        raise ValueError(
            f"O valor para {field} : {value} deve pertencer ao conjunto: {values_set}"
        )

    if format:
        value = value_text_string(value)

    return {"id": FIELD2ID[field], "value": value}


def view_string(s):
    """Recebe uma string formatada como json e retorna somente o valor 'value' da string"""
    try:
        d = json.loads(s)
        return d.get("valor", s)
    except json.JSONDecodeError:
        return s