# ------------------------------------------------------------
# This file was generated using create_markov_trace_data.py
#
# on    : Version 2022.3.1
# under : Sage SageMath version 9.6.beta3, Release Date: 2022-02-27
# using : Python 3.8.10
# ------------------------------------------------------------

# generated data function for cubic Hecke algebra
def read_markov(bas_ele, variables, num_strands=4):
    r"""
    Return precomputed Markov trace coefficients.

    This code has been generated by ``create_markov_trace_data.py`` (from
    the `database_cubic_hecke repository  <https://github.com/soehms/database_cubic_hecke>`__),
    please don't edit.

    INPUT:

    - ``bas_ele`` -- instance of enum :class:`MarkovTraceModuleBasis`
    - ``variables`` -- tuple consisting of the variables used in
      the coefficients
    - ``num_strands`` -- integer indicating the number of strands (default 4)


    OUTPUT:

    A list of the coefficients. The i'th member corresponds to the i'th
    basis element.

    EXAMPLES::

        >>> from database_cubic_hecke.markov_trace_coeffs import read_markov
        >>> from sympy import var
        >>> u, v, w, s = var('u, v, w, s')
        >>> variables = (u, v, w, s)
        >>> read_markov('U2', variables, num_strands=3) # doctest: +NORMALIZE_WHITESPACE
        [0, s, 1/s, s, 1/s, 0, 0, 0, 0, -s*v, s, s, -s*u/w, -v/s, 1/s,
         0, 0, 0, 0, 1/s, -u/(s*w), -v/s, 0, 0]

    """

    u, v, w, s = variables
    data = {}
    data[2] = {'U1': [0, s, 1/s], 'U2': [1, 0, 0]}
    data[3] = {'U1': [0, 0, 0, 0, 0, s**2, 1, 1, 1/s**2, u*s**2 + w, 0, 0, (s**2 +
        v)/w, (u*s**2 + w)/s**2, 0, s**2, 1, 1, 1/s**2, 0, (s**2 +
        v)/(w*s**2), (u*s**2 + w)/s**2, s**2, 0], 'U2': [0, s, 1/s, s,
        1/s, 0, 0, 0, 0, -v*s, s, s, (-u*s)/w, (-v)/s, 1/s, 0, 0, 0,
        0, 1/s, (-u)/(w*s), (-v)/s, 0, 0], 'U3': [1, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], 'K4': [0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 1]}
    data[4] = {'U1': [0, (u*s**4 + u*v*s**2 + w*s**2 + v*w)/(w*s**3), (u*s**4 +
        u*v*s**2 + w*s**2 + v*w)/(w*s), 0, 0, 0, 0, 0, 0, 1/s**3, 1/s,
        1/s, s, 1/s, s, s, s**3, (s**3 + v*s)/w, (s**2 + v)/(w*s), 0,
        (u*s**2 + w)/s, (u*s**2 + w)/s**3, (-u**2*s**6 + 2*u**2*v*s**4
        - u**2*v**2*s**2 - v**2*s**4 + u*v*w*s**2 -
        u*v**2*w)/(w*s**3), 0, s, 0, s**3, 0, (s**3 + v*s)/w, 0, 0, 0,
        1/s, s, s, s**3, 0, (u*s**2 + w)/s**3, 0, (u*s**2 + w)/s, 0,
        (u*s**2 + w)/s, 0, u*s**3 + w*s, 0, 0, (u*s**2 + w)/s,
        (u**2*s**4 + 2*u*w*s**2 + w**2)/s**3, 0, (-u**3*s**6 +
        2*u**3*v*s**4 - u**3*v**2*s**2 - u*v**2*s**4 + u**2*v*w*s**2 -
        u**2*v**2*w + u*w**2*s**2 + w**3)/(w*s**3), (u*s**2 + w)/s**3,
        (u*s**2 + w)/s, (-u**2*s**6 + 2*u**2*v*s**4 - u**2*v**2*s**2 -
        v**2*s**4 + u*v*w*s**2 - u*v**2*w)/(w*s**3), (u*s**4 -
        u*v*s**2 - v*w)/s, 0, 0, (u*s**2 + w)/s**3, 0, 0, 1/s**3, 1/s,
        1/s, s, (s**2 + v)/(w*s**3), 0, (s**2 + v)/(w*s), 0, (s**2 +
        v)/(w*s), 0, (s**3 + v*s)/w, 0, 1/s, 1/s**3, (u*s**2 +
        w)/s**3, 0, (u*s**4 + u*v*s**2 + w*s**2 + v*w)/(w*s**3), 0,
        (-u**2*s**2 + s**4 - u*w)/(w*s**3), 0, (u*s**2 + w)/s**3,
        (u*s**2 + w)/s, 0, (-v*s**4 - v**2*s**2 + w**2)/(w*s**3), 0,
        0, 0, 0, 0, 0, 0, 0, 0, (u*s**2 + w)/s**3, (u*s**2 + w)/s, 0,
        0, (u*s**2 + w)/s, u*s**3 + w*s, s, 1/s, 0, s**3, s,
        (u**2*s**2 - v*s**2 + u*w)/s, (u*s**2 + w)/s**3, (u*s**4 -
        u*v*s**2 - v*w)/s**3, (u*s**2 + w)/s, (u*s**4 - u*v*s**2 -
        v*w)/s, 0, 0, (-u**2*s**2 + s**4 - u*w)/(w*s), 0, 0, 0, 0, 0,
        0, (s**2 + v)/(w*s**3), (s**2 + v)/(w*s), 0, 0, (s**2 +
        v)/(w*s), (s**3 + v*s)/w, 0, 0, (v*s**3 + v**2*s -
        u*w*s)/w**2, (v*s**2 + v**2 - u*w)/(w**2*s), 0, 0, 0,
        (-u**2*v*s**6 + 2*u**2*v**2*s**4 - u**3*w*s**4 + u*w*s**6 -
        u**2*v**3*s**2 - v**3*s**4 + 2*u*v**2*w*s**2 - u**2*w**2*s**2
        - u*v**3*w + v**2*w**2)/(w**2*s**3), (-u**2*s**2 + s**4 -
        u*w)/(w*s**3), (u*s**2 + w)/s**3, (-u**2*s**2 + s**4 -
        u*w)/(w*s), (u*s**2 + w)/s, 0, 0, s**3, s**3, s, 0, (u*s**2 +
        w)/s, 0, u*s**3 + w*s, 0, 0, 0, (u**2*s**4 + 2*u*w*s**2 +
        w**2)/s**3, 0, 0, 0, (u**2*s**4 + 2*u*w*s**2 + w**2)/s,
        (u*s**2 + w)/s, (u*s**2 + w)/s**3, s**3, u*s**3 + w*s, 0,
        (u**3*s**2 - 2*u*v*s**2 + u**2*w + w*s**2 - v*w)/s, s, s**3,
        (u**2*s**2 - v*s**2 + u*w)/s, (u**2*s**4 - u**2*v*s**2 -
        v*s**4 + u*w*s**2 - u*v*w + w**2)/s, 0, 1/s, (-u**2*v*s**6 +
        2*u**2*v**2*s**4 - u**3*w*s**4 + u*w*s**6 - u**2*v**3*s**2 -
        v**3*s**4 + 2*u*v**2*w*s**2 - u**2*w**2*s**2 - u*v**3*w +
        v**2*w**2)/(w**2*s**3), s, 1/s, (s**2 + v)/(w*s), 0, (s**3 +
        v*s)/w, 0, 0, (u*s**4 + u*v*s**2 + w*s**2 + v*w)/(w*s**3), 0,
        0, 0, (u*s**4 + u*v*s**2 + w*s**2 + v*w)/(w*s), 0, 0,
        (-u**2*s**2 + s**4 - u*w)/(w*s), (-u**2*s**2 + s**4 -
        u*w)/(w*s**3), 0, 0, 0, (-u**3*v*s**6 + 2*u**3*v**2*s**4 -
        u**4*w*s**4 + u**2*w*s**6 - u**3*v**3*s**2 - u*v**3*s**4 +
        u**2*v*w*s**4 - v*w*s**6 + 2*u**2*v**2*w*s**2 - u**3*w**2*s**2
        - u**2*v**3*w + u*v*w**2*s**2 + u*v**2*w**2)/(w**2*s**3), 0,
        0, (-u**2*v*s**6 + 2*u**2*v**2*s**4 - u**3*w*s**4 + u*w*s**6 -
        u**2*v**3*s**2 - v**3*s**4 + 2*u*v**2*w*s**2 - u**2*w**2*s**2
        - u*v**3*w + v**2*w**2)/(w**2*s**3), s**3, 0, (-u**2*s**6 +
        2*u**2*v*s**4 - u**2*v**2*s**2 - 2*v**2*s**4 - v**3*s**2 +
        2*u*v*w*s**2 - u*v**2*w + 2*v*w**2)/(w**2*s**3), s, s, 1/s, 0,
        (u*s**2 + w)/s**3, 0, (u*s**2 + w)/s, 0, 0, (u*s**4 + u*v*s**2
        + w*s**2 + v*w)/(w*s**3), 0, 0, 0, (u*s**4 + u*v*s**2 + w*s**2
        + v*w)/(w*s), 0, 0, 0, s, 0, (s**3 + v*s)/w, (u*s**2 + w)/s,
        0, 0, s, s**3, 0, 1/s**3, 0, 1/s, 1/s**3, (s**2 + v)/(w*s**3),
        0, (s**2 + v)/(w*s), 0, (s**4 + 2*v*s**2 + v**2)/(w**2*s**3),
        0, 0, 0, (s**4 + 2*v*s**2 + v**2)/(w**2*s), 0, 0, 0, (s**2 +
        v)/(w*s), (s**2 + v)/(w*s**3), 0, 0, 0, (-u**2*s**2 + s**4 -
        u*w)/(w*s), (-u**2*v*s**2 + v*s**4 + u*w*s**2 - u*v*w +
        w**2)/(w**2*s**3), (-u**2*s**6 + 2*u**2*v*s**4 -
        u**2*v**2*s**2 - v**2*s**4 + 2*u*v*w*s**2 - u*v**2*w +
        v*w**2)/(w**2*s**3), 0, 0, 0, (-u**2*s**6 + 2*u**2*v*s**4 -
        u**2*v**2*s**2 - v**2*s**4 + u*v*w*s**2 - u*v**2*w)/(w*s**3),
        (-u**2*v*s**4 - u**2*v**2*s**2 - u**3*w*s**2 + 2*u*w*s**4 -
        u*v**2*w - u**2*w**2 + w**2*s**2 + v*w**2)/(w*s), u*s**3 +
        w*s, (u*s**2 + w)/s, s, (u**2*s**2 - v*s**2 + u*w)/s, s**3,
        u**2*s**3 - v*s**3 + u*w*s, 0, (u*s**2 + w)/s, (u*s**2 + w)/s,
        (u**3*s**2 - 2*u*v*s**2 + u**2*w + w*s**2 - v*w)/s, 0, u*s**3
        + w*s, u*s**3 + w*s, u**3*s**3 - 2*u*v*s**3 + u**2*w*s +
        w*s**3 - v*w*s, 0, 0, (u*s**4 - u*v*s**2 - v*w)/s, (u**2*s**4
        - u**2*v*s**2 - v*s**4 + u*w*s**2 - u*v*w + w**2)/s, s**3,
        (u**2*s**6 - u**2*v*s**4 + u*w*s**4 - 2*u*v*w*s**2 -
        v*w**2)/s**3, 0, u*s**3 + w*s, u*s**3 + w*s, (u**3*s**4 -
        u**3*v*s**2 - 2*u*v*s**4 + 2*u**2*w*s**2 - u**2*v*w -
        2*v*w*s**2 + 2*u*w**2)/s, 0, (u*s**2 + w)/s**3, (u**2*s**4 +
        u**2*v*s**2 - v*s**4 - v**2*s**2 + u*w*s**2 + u*v*w)/(w*s), 0,
        0, 1/s, s, s, s**3, 0, (u*s**2 + w)/s**3, (u*s**2 + w)/s**3,
        (u*s**4 - u*v*s**2 - v*w)/s**3, 0, (u*s**2 + w)/s, (u*s**2 +
        w)/s, (u*s**4 - u*v*s**2 - v*w)/s, (u*s**4 + u*v*s**2 + w*s**2
        + v*w)/(w*s), (u*s**4 + u*v*s**2 + w*s**2 + v*w)/(w*s**3),
        (u*s**2 + w)/s, (u**2*s**2 - v*s**2 + u*w)/s, s, (-u**3*s**6 +
        2*u**3*v*s**4 - u*v*s**6 - u**3*v**2*s**2 - 2*u*v**2*s**4 +
        u**2*v*w*s**2 + v*w*s**4 - u**2*v**2*w + 2*u*w**2*s**2 +
        w**3)/(w*s**3), (s**3 + v*s)/w, 0, (-v*s**4 - v**2*s**2 +
        w**2)/(w*s), u*s**3 + w*s, 0, (u*s**2 + w)/s**3, (u**2*s**4 +
        u**2*v*s**2 - v*s**4 - v**2*s**2 + u*w*s**2 + u*v*w)/(w*s), 0,
        0, 1/s, s, s, s**3, (s**2 + v)/(w*s), 0, 0, (u*s**2 + w)/s,
        (s**3 + v*s)/w, 0, 0, u*s**3 + w*s, (u*s**4 + u*v*s**2 +
        w*s**2 + v*w)/(w*s), (u*s**4 + u*v*s**2 + w*s**2 +
        v*w)/(w*s**3), (u*s**2 + w)/s, s**3, 0, (u**2*s**4 +
        2*u*w*s**2 + w**2)/s**3, 0, 0, 0, (-u**2*v*s**6 +
        2*u**2*v**2*s**4 - u**3*w*s**4 + 2*u*w*s**6 - u**2*v**3*s**2 -
        v**3*s**4 + 2*u*v**2*w*s**2 - u**2*w**2*s**2 - u*v**3*w +
        v**2*w**2)/(w*s**3), 0, (-2*u**2*v*s**6 + u**2*v**2*s**4 +
        u*w*s**6 - u**2*v**3*s**2 - 2*v**3*s**4 + u*v*w*s**4 -
        v**4*s**2 + 2*u*v**2*w*s**2 - u*v**3*w - v*w**2*s**2 +
        2*v**2*w**2 - u*w**3)/(w**3*s**3), (-u**3*s**4 - u**3*v*s**2 -
        u**2*w*s**2 + w*s**4 - u**2*v*w + 2*v*w*s**2 +
        u*w**2)/(w**2*s), (s**3 + v*s)/w, (s**2 + v)/(w*s), 1/s**3, 0,
        1/s, 0, (s**2 + v)/(w*s**3), 0, (-u**2*s**2 + s**4 -
        u*w)/(w*s**3), (u*s**2 + w)/s**3, (s**2 + v)/(w*s), 0,
        (-u**2*s**2 + s**4 - u*w)/(w*s), (u*s**2 + w)/s, (-u**2*s**4 -
        u**2*v*s**2 - v*s**4 - v**2*s**2 - u*w*s**2 - u*v*w +
        w**2)/(w**2*s), (-u**2*s**4 - u**2*v*s**2 - v*s**4 - v**2*s**2
        - u*w*s**2 - u*v*w + w**2)/(w**2*s**3), 0, s, 1/s, 0, 0,
        (-u*v*s**4 - u*v**2*s**2 + w*s**4 + v*w*s**2 +
        u*w**2)/(w**2*s), (-u**3*s**6 + 2*u**3*v*s**4 - u**3*v**2*s**2
        - u*v**2*s**4 + u**2*v*w*s**2 + v*w*s**4 - u**2*v**2*w +
        u*w**2*s**2 + w**3)/(w**2*s**3), 0, 0, (-u*v**2*s**4 -
        u*v**3*s**2 + v*w*s**4 - v**2*w*s**2 + 2*u*w**2*s**2 - v**3*w
        + w**3)/(w**2*s**3), (-2*u**3*v*s**6 + 4*u**3*v**2*s**4 -
        u**4*w*s**4 + u**2*w*s**6 - 2*u**3*v**3*s**2 - 2*u*v**3*s**4 -
        v*w*s**6 + 3*u**2*v**2*w*s**2 - u**3*w**2*s**2 - u*w**2*s**4 -
        2*u**2*v**3*w + u*v*w**2*s**2 + u*v**2*w**2 +
        v*w**3)/(w**2*s**3), (u*s**2 + w)/s, (u*s**2 + w)/s**3, 0, s,
        0, s**3, (s**2 + v)/(w*s), (-v*s**4 - v**2*s**2 +
        w**2)/(w*s**3), 0, (u*s**2 + w)/s, (s**3 + v*s)/w, (-v*s**4 -
        v**2*s**2 + w**2)/(w*s), 0, u*s**3 + w*s, (-u**2*v*s**4 -
        u**2*v**2*s**2 - u**3*w*s**2 - v**2*s**4 + 2*u*w*s**4 -
        v**3*s**2 - u*v**2*w - u**2*w**2 + w**2*s**2 +
        2*v*w**2)/(w**2*s), (-u**2*v*s**4 - u**2*v**2*s**2 -
        u**3*w*s**2 - v**2*s**4 + 2*u*w*s**4 - v**3*s**2 - u*v**2*w -
        u**2*w**2 + w**2*s**2 + 2*v*w**2)/(w**2*s**3), (-u**2*s**6 +
        2*u**2*v*s**4 - u**2*v**2*s**2 - v**2*s**4 + u*v*w*s**2 -
        u*v**2*w)/(w*s**3), (-u**3*s**6 + 2*u**3*v*s**4 -
        u**3*v**2*s**2 - u*v**2*s**4 + u**2*v*w*s**2 - u**2*v**2*w +
        u*w**2*s**2 + w**3)/(w*s**3), 0, (-2*u**4*v*s**6 +
        4*u**4*v**2*s**4 - u**5*w*s**4 + u**2*v**2*s**6 + u**3*w*s**6
        - 2*u**4*v**3*s**2 - 4*u**2*v**3*s**4 + u**3*v*w*s**4 -
        2*u*v*w*s**6 + u**2*v**4*s**2 + 3*u**3*v**2*w*s**2 -
        u**4*w**2*s**2 + v**4*s**4 + u*v**2*w*s**4 - u**2*w**2*s**4 -
        2*u**3*v**3*w - u*v**3*w*s**2 + 3*u**2*v*w**2*s**2 + u*v**4*w
        + u**2*v**2*w**2 + v**2*w**2*s**2 + 2*u*v*w**3)/(w**2*s**3),
        (s**3 + v*s)/w, (-v*s**4 - v**2*s**2 + w**2)/(w*s),
        (-2*u**3*v*s**6 + 4*u**3*v**2*s**4 - u**4*w*s**4 + u**2*w*s**6
        - 2*u**3*v**3*s**2 - 2*u*v**3*s**4 - v*w*s**6 +
        3*u**2*v**2*w*s**2 - u**3*w**2*s**2 - u*w**2*s**4 -
        2*u**2*v**3*w + u*v*w**2*s**2 + u*v**2*w**2 +
        v*w**3)/(w**2*s**3), u*s**3 + w*s, 0, (u*v*s**4 + u*v**2*s**2
        - u**2*w*s**2 + v*w*s**2 + v**2*w - u*w**2)/(w**2*s**3), (s**3
        + v*s)/w, 0, 0, 1/s**3, 1/s, 1/s, s, (-u*s**4 - u*v*s**2 +
        v*w)/(w**2*s**3), (s**2 + v)/(w*s), (s**2 + v)/(w*s), 0,
        (-u*s**4 - u*v*s**2 + v*w)/(w**2*s), (s**3 + v*s)/w, (s**3 +
        v*s)/w, 0, 0, 0, (u*s**2 + w)/s**3, 0, (-u**2*s**6 +
        2*u**2*v*s**4 - u**2*v**2*s**2 - v**2*s**4 + 2*u*v*w*s**2 -
        u*v**2*w + v*w**2)/(w**2*s**3), (-u**2*v*s**6 +
        2*u**2*v**2*s**4 - u**3*w*s**4 + u*w*s**6 - u**2*v**3*s**2 -
        v**3*s**4 - u*v*w*s**4 + u*v**2*w*s**2 - 2*u**2*w**2*s**2 -
        u*v**3*w - v*w**2*s**2 - u*w**3)/(w**2*s**3), 0, (-u**3*s**6 +
        2*u**3*v*s**4 - u**3*v**2*s**2 - u*v**2*s**4 + u**2*v*w*s**2 +
        v*w*s**4 - u**2*v**2*w + u*w**2*s**2 + w**3)/(w**2*s**3), 0,
        0, 0, 0, s**3, s**3, s, 0, (u*s**2 + w)/s, 0, u*s**3 + w*s,
        1/s, s, s, (u**2*s**2 - v*s**2 + u*w)/s, s, s**3, s**3,
        u**2*s**3 - v*s**3 + u*w*s, (u*s**2 + w)/s, (u*s**2 + w)/s**3,
        s**3, (u*s**4 - u*v*s**2 - v*w)/s, (u*s**2 + w)/s, u*s**3 +
        w*s, 0, (u**2*s**4 + 2*u*w*s**2 + w**2)/s**3, (u**2*s**4 +
        2*u*w*s**2 + w**2)/s**3, (-u**2*v**2*s**2 - v**2*s**4 -
        2*u*v*w*s**2 - u*v**2*w - v*w**2)/s**3, 0, 1/s, (-u**2*v*s**6
        + 2*u**2*v**2*s**4 - u**3*w*s**4 + u*w*s**6 - u**2*v**3*s**2 -
        v**3*s**4 + 2*u*v**2*w*s**2 - u**2*w**2*s**2 - u*v**3*w +
        v**2*w**2)/(w**2*s**3), s, 1/s, (s**2 + v)/(w*s), 0, (s**3 +
        v*s)/w, 0, 1/s**3, 0, 1/s, s, 1/s, 0, s, s**3, (-u**2*s**2 +
        s**4 - u*w)/(w*s), (-u**2*s**2 + s**4 - u*w)/(w*s**3), 0,
        (-u**2*s**6 + 2*u**2*v*s**4 - u**2*v**2*s**2 - v**2*s**4 +
        u*v*w*s**2 - u*v**2*w)/(w*s**3), (u*s**2 + w)/s**3,
        (-2*u**3*v*s**6 + 4*u**3*v**2*s**4 - u**4*w*s**4 + u**2*w*s**6
        - 2*u**3*v**3*s**2 - 2*u*v**3*s**4 - v*w*s**6 +
        3*u**2*v**2*w*s**2 - u**3*w**2*s**2 - u*w**2*s**4 -
        2*u**2*v**3*w + u*v*w**2*s**2 + u*v**2*w**2 +
        v*w**3)/(w**2*s**3), (u*s**4 + u*v*s**2 + w*s**2 +
        v*w)/(w*s**3), 0, (-u**2*v*s**6 + 2*u**2*v**2*s**4 -
        u**3*w*s**4 + u*w*s**6 - u**2*v**3*s**2 - v**3*s**4 -
        u*v*w*s**4 + u*v**2*w*s**2 - 2*u**2*w**2*s**2 - u*v**3*w -
        v*w**2*s**2 - u*w**3)/(w**2*s**3), (u**2*s**4 + 2*u*w*s**2 +
        w**2)/s**3, 0, (-u**2*s**6 + 2*u**2*v*s**4 - u**2*v**2*s**2 -
        2*v**2*s**4 - v**3*s**2 + 2*u*v*w*s**2 - u*v**2*w +
        2*v*w**2)/(w**2*s**3), s, s, 1/s, 0, (u*s**2 + w)/s**3, 0,
        (u*s**2 + w)/s, 1/s**3, 1/s, 0, s, 1/s, s, 0, s**3, 0, 0, s,
        (u*s**2 + w)/s, 0, (-v*s**4 - v**2*s**2 + w**2)/(w*s), (u*s**4
        + u*v*s**2 + w*s**2 + v*w)/(w*s**3), (-u*v*s**4 - u*v**2*s**2
        - u**2*w*s**2 + w*s**4 - v*w*s**2 - v**2*w - u*w**2)/(w*s**3),
        0, (u**2*s**4 + 2*u*w*s**2 + w**2)/s**3, 0, 1/s**3, 0, 1/s,
        1/s**3, (s**2 + v)/(w*s**3), 0, (s**2 + v)/(w*s), 0, (v*s**2 +
        v**2 - u*w)/(w**2*s**3), 1/s**3, 1/s**3, 1/s, (v*s**2 + v**2 -
        u*w)/(w**2*s), 1/s, 1/s, s, (s**2 + v)/(w*s), (s**2 +
        v)/(w*s**3), 0, (u*s**2 + w)/s**3, (-u**2*s**2 + s**4 -
        u*w)/(w*s**3), (s**3 + v*s)/w, (-u**2*s**4 - 2*u**2*v*s**2 +
        v*s**4 - u*w*s**2 - 2*u*v*w)/(w**2*s**3), (u*s**4 + u*v*s**2 +
        w*s**2 + v*w)/(w*s**3), (u*s**4 + u*v*s**2 + w*s**2 +
        v*w)/(w*s**3), 0, 0, (u*v*s**4 + u*v**2*s**2 - u**2*w*s**2 +
        v*w*s**2 + v**2*w - u*w**2)/(w**2*s**3), (s**3 + v*s)/w, 0, 0,
        1/s**3, 1/s, 1/s, s, (s**2 + v)/(w*s**3), 0, 0, (u*s**2 +
        w)/s**3, (s**2 + v)/(w*s), 0, 0, (u*s**2 + w)/s, 0, 0, (u*s**2
        + w)/s**3, s, 0, (u*s**6 - u*v**2*s**2 - v*w*s**2 -
        v**2*w)/(w*s**3), (-u*s**3 - u*v*s)/w**2, (s**3 + v*s)/w,
        (s**3 + v*s)/w, 0, 0, (-u**2*v*s**4 - u**2*v**2*s**2 -
        v**2*s**4 + u*w*s**4 - v**3*s**2 - u*v**2*w + w**2*s**2 +
        2*v*w**2)/(w**3*s**3), (-u*s**3 - u*v*s)/w**2, (s**2 +
        v)/(w*s), (s**2 + v)/(w*s**3), (v*s**2 + v**2 -
        u*w)/(w**2*s**3), 1/s**3, (v*s**2 + v**2 - u*w)/(w**2*s), 1/s,
        (v**2*s**2 - u*w*s**2 + v**3 - 2*u*v*w + w**2)/(w**3*s**3),
        (s**2 + v)/(w*s**3), (s**2 + v)/(w*s**3), 0, (v**2*s**2 -
        u*w*s**2 + v**3 - 2*u*v*w + w**2)/(w**3*s), (s**2 + v)/(w*s),
        (s**2 + v)/(w*s), 0, (s**4 + 2*v*s**2 + v**2)/(w**2*s), (s**4
        + 2*v*s**2 + v**2)/(w**2*s**3), (-u**2*s**2 + s**4 -
        u*w)/(w*s**3), 0, (-u**2*v*s**2 + v*s**4 + u*w*s**2 - u*v*w +
        w**2)/(w**2*s**3), (u*s**4 + u*v*s**2 + w*s**2 +
        v*w)/(w*s**3), (-u**2*s**6 + 2*u**2*v*s**4 - 2*u**2*v**2*s**2
        + 3*u*v*w*s**2 - 2*u*v**2*w + 2*v*w**2)/(w**3*s**3), 0, 0, 0,
        0, (u**3*v*s**6 + u**3*v**2*s**4 - u*v**3*s**4 -
        3*u**2*v*w*s**4 - u*v**4*s**2 + u**2*v**2*w*s**2 +
        2*v**2*w*s**4 - v**3*w*s**2 - v**4*w + u*v**2*w**2 +
        u**2*w**3)/(v*w**2*s**3), 0, (u*s**2 + w)/s, (u*s**2 +
        w)/s**3, 1/s, (u**2*s**2 - v*s**2 + u*w)/s**3, s, (u**2*s**2 -
        v*s**2 + u*w)/s, (s**2 + v)/(w*s), 0, (-v*s**4 - v**2*s**2 +
        w**2)/(w*s**3), (u*s**2 + w)/s, (s**3 + v*s)/w, 0, (-v*s**4 -
        v**2*s**2 + w**2)/(w*s), u*s**3 + w*s, 0, 0, (u*s**4 -
        u*v*s**2 - v*w)/s**3, s**3, 0, (-u*v*s**6 + w*s**6 +
        u*v**3*s**2 + u**2*v*w*s**2 + v**2*w*s**2 + u*w**2*s**2 +
        v**3*w + u*v*w**2)/(w*s**3), (s**3 + v*s)/w, (-v*s**3 -
        v**2*s)/w, 0, u*s**3 + w*s, 0, (u**2*s**2 - v*s**2 +
        u*w)/s**3, (u**2*v**3*s**6 - 2*u**2*v**4*s**4 +
        4*u**3*v**2*w*s**4 - u**4*w**2*s**4 - 2*u*v**2*w*s**6 +
        u**2*v**5*s**2 - u**3*v**3*w*s**2 + v**5*s**4 -
        2*u*v**3*w*s**4 + v*w**2*s**6 - 2*u*v**4*w*s**2 +
        4*u**2*v**2*w**2*s**2 - u**3*w**3*s**2 + v**2*w**2*s**4 -
        u*w**3*s**4 + u*v**5*w - u**2*v**3*w**2 - u*v*w**3*s**2 -
        v**4*w**2 + u*v**2*w**3)/(v*w**2*s**3), s**3, s, 0, (u*s**2 +
        w)/s, 0, u*s**3 + w*s, 1/s, s, (u**2*s**2 - v*s**2 +
        u*w)/s**3, (u**2*s**4 - u**2*v*s**2 - v*s**4 + u*w*s**2 -
        u*v*w + w**2)/s**3, s, s**3, (u**2*s**2 - v*s**2 + u*w)/s,
        (u**2*s**4 - u**2*v*s**2 - v*s**4 + u*w*s**2 - u*v*w +
        w**2)/s, 0, 0, s**3, (u*s**6 - u*v*s**4 + u*v**2*s**2 +
        v**2*w)/s**3, (u*s**4 - u*v*s**2 - v*w)/s**3, (-u**2*v*s**6 +
        u*w*s**6 + u**2*v**3*s**2 + u**3*v*w*s**2 - u*v*w*s**4 +
        w**2*s**4 + u*v**3*w + u**2*v*w**2 - v*w**2*s**2 - v**2*w**2 -
        u*w**3)/(w*s**3), (u*s**6 - u*v**2*s**2 - v*w*s**2 -
        v**2*w)/(w*s**3), 0, (-u*v*s**6 + w*s**6 + u*v**3*s**2 +
        u**2*v*w*s**2 + v**2*w*s**2 + u*w**2*s**2 + v**3*w +
        u*v*w**2)/(w*s**3), (u**2*s**6 - u**2*v*s**4 + u*w*s**4 -
        2*u*v*w*s**2 - v*w**2)/s**3, 0, 0, 0, 0, 0, (s**2 + v)/(w*s),
        (-v*s**4 - v**2*s**2 + w**2)/(w*s**3), (s**3 + v*s)/w,
        (-v*s**4 - v**2*s**2 + w**2)/(w*s), (v*s**2 + v**2 -
        u*w)/(w**2*s), 1/s, (-u**3*w*s**2 - v**2*s**4 + u*w*s**4 -
        v**3*s**2 + u*v*w*s**2 - u**2*w**2 + w**2*s**2 +
        v*w**2)/(w**2*s**3), (u**2*s**2 - v*s**2 + u*w)/s**3, (v*s**3
        + v**2*s - u*w*s)/w**2, s, (-u**3*w*s**2 - v**2*s**4 +
        u*w*s**4 - v**3*s**2 + u*v*w*s**2 - u**2*w**2 + w**2*s**2 +
        v*w**2)/(w**2*s), (u**2*s**2 - v*s**2 + u*w)/s, 0, 0, 0,
        (u*s**4 - u*v*s**2 - v*w)/s**3, (-u**2*s**4 + s**6 +
        u**2*v*s**2 + u*v*w)/(w*s**3), 0, (u*s**4 + u*v*s**2 + w*s**2
        + v*w)/(w*s**3), (-2*u**2*v*s**6 + 2*u**2*v**2*s**4 -
        u**3*w*s**4 + 2*u*w*s**6 + u**3*v*w*s**2 - v**3*s**4 -
        u*v*w*s**4 + 2*u*v**2*w*s**2 - u**2*w**2*s**2 + u**2*v*w**2 -
        2*v*w**2*s**2 - u*w**3)/(w**2*s**3), (-u*v*s**4 - u*v**2*s**2
        - u**2*w*s**2 + w*s**4 - v*w*s**2 - v**2*w - u*w**2)/(w*s**3),
        (u**2*s**4 + 2*u*w*s**2 + w**2)/s**3], 'U2': [0, (-u**2*s**2 -
        v*s**2 - v**2 - u*w)/(w*s**2), (-u**2*s**2 - v*s**2 - v**2 -
        u*w)/w, 0, 0, 1/s**2, 1, 1, s**2, 0, 0, 0, 0, 0, 0, 0, 0,
        (-u*s**2)/w, (-u)/w, (u*s**2 + w)/s**2, -v, (-v)/s**2,
        (-u*v**2*s**2 + u*v**3 + v*w*s**2)/(w*s**2), 0, 0, 0, 0, 0,
        (-u*s**2)/w, 0, s**2, 1, 0, 0, 0, 0, 1/s**2, (-v)/s**2, 1, -v,
        1, -v, s**2, -v*s**2, 0, 0, -v, (-2*u*v*s**2 - 2*v*w)/s**2,
        (u*s**2 + w)/s**2, (-u**2*v**2*s**2 + u**2*v**3 + u*v*w*s**2 -
        v*w**2)/(w*s**2), (-v)/s**2, -v, (-u*v**2*s**2 + u*v**3 +
        v*w*s**2)/(w*s**2), v**2, 0, 0, (-v)/s**2, 1, 1/s**2, 0, 0, 0,
        0, (-u)/(w*s**2), 1/s**2, (-u)/w, 1, (-u)/w, 1, (-u*s**2)/w,
        s**2, 0, 0, (-v)/s**2, (u*s**2 + w)/s**2, (-u**2*s**2 - v*s**2
        - v**2 - u*w)/(w*s**2), 0, u*v/(w*s**2), 1, (-v)/s**2, -v, 0,
        u*v/w, s**2, s**2, 1, 0, (u*s**2 + w)/s**2, 0, u*s**2 + w,
        1/s**2, 1, (-v)/s**2, -v, 1, s**2, -v, -v*s**2, 0, 0, s**2, 0,
        0, -u*v + w, (-v)/s**2, v**2/s**2, -v, v**2, 0, 1/s**2, u*v/w,
        1, 1/s**2, (s**2 + v)/(w*s**2), 0, (s**2 + v)/w, 0,
        (-u)/(w*s**2), (-u)/w, 1/s**2, 1, (-u)/w, (-u*s**2)/w, 1,
        s**2, (-u*v*s**2 + w*s**2)/w**2, (-u*v + w)/w**2, 0, 0, 0,
        (-u*v**3*s**2 + u**2*v*w*s**2 + u*v**4 + v**2*w*s**2 -
        u*w**2*s**2 - v**3*w)/(w**2*s**2), u*v/(w*s**2), (-v)/s**2,
        u*v/w, -v, s**2, 0, 0, 0, 0, 1, -v, s**2, -v*s**2, 0, (u*s**2
        + w)/s**2, (u*s**2 + w)/s**2, (-2*u*v*s**2 - 2*v*w)/s**2, 0,
        u*s**2 + w, u*s**2 + w, -2*u*v*s**2 - 2*v*w, -v, (-v)/s**2, 0,
        -v*s**2, s**2, -u**2*v + v**2 + u*w, 0, 0, -u*v + w, u*v**2 -
        v*w, 1, 0, (-u*v**3*s**2 + u**2*v*w*s**2 + u*v**4 +
        v**2*w*s**2 - u*w**2*s**2 - v**3*w)/(w**2*s**2), 0, 0, (-u)/w,
        1, (-u*s**2)/w, s**2, (s**2 + v)/(w*s**2), (-u**2*s**2 -
        v*s**2 - v**2 - u*w)/(w*s**2), 0, (u*s**2 + w)/s**2, (s**2 +
        v)/w, (-u**2*s**2 - v*s**2 - v**2 - u*w)/w, 0, u*s**2 + w,
        u*v/w, u*v/(w*s**2), 0, 0, 0, (-u**2*v**3*s**2 + u**3*v*w*s**2
        + u**2*v**4 - u**2*w**2*s**2 - u*v**3*w)/(w**2*s**2), 0, 0,
        (-u*v**3*s**2 + u**2*v*w*s**2 + u*v**4 + v**2*w*s**2 -
        u*w**2*s**2 - v**3*w)/(w**2*s**2), 0, 1, (u*v**3 -
        v**2*w)/(w**2*s**2), 0, 0, 0, 1/s**2, (-v)/s**2, 1, -v, (s**2
        + v)/(w*s**2), 0, (-u**2*s**2 - v*s**2 - v**2 - u*w)/(w*s**2),
        (u*s**2 + w)/s**2, (s**2 + v)/w, 0, (-u**2*s**2 - v*s**2 -
        v**2 - u*w)/w, u*s**2 + w, 1, 1/s**2, 0, s**2, (-u*s**2)/w,
        -v, 0, 0, 0, 0, 1/s**2, 0, 0, 0, 0, (-u)/(w*s**2), 1/s**2,
        (-u)/w, 1, (-2*u*s**2 - 2*u*v)/(w**2*s**2), (s**2 +
        v)/(w*s**2), (s**2 + v)/(w*s**2), 0, (-2*u*s**2 - 2*u*v)/w**2,
        (s**2 + v)/w, (s**2 + v)/w, 0, (-u)/w, (-u)/(w*s**2), 0, 0, 0,
        u*v/w, (u*v**2 - v*w)/(w**2*s**2), (-u*v**2*s**2 + u*v**3 +
        v*w*s**2 - v**2*w)/(w**2*s**2), 0, 0, u*s**2 + w,
        (-u*v**2*s**2 + u*v**3 + v*w*s**2)/(w*s**2), (u**3*v*s**2 +
        u*v**2*s**2 + u*v**3 + 2*u**2*v*w - 2*v*w*s**2 - v**2*w -
        u*w**2)/w, -v*s**2, -v, 0, -u*v + w, 0, -u*v*s**2 + w*s**2, 1,
        -v, -v, -u**2*v + v**2 + u*w, s**2, -v*s**2, -v*s**2,
        -u**2*v*s**2 + v**2*s**2 + u*w*s**2, u*s**2 + w, (u*s**2 +
        w)/s**2, v**2, u*v**2 - v*w, 0, (-u*v*s**4 + 2*u*v**2*s**2 +
        2*v**2*w)/s**2, s**2, -v*s**2, -v*s**2, u**2*v**2 + v**2*s**2
        - 2*u*v*w + w**2, 0, (-v)/s**2, (-u**3*s**2 - u*v**2 - u**2*w
        + w*s**2 + v*w)/w, s**2, 1, 0, 0, 0, 0, 1/s**2, (-v)/s**2,
        (-v)/s**2, v**2/s**2, 1, -v, -v, v**2, (-u**2*s**2 - v*s**2 -
        v**2 - u*w)/w, (-u**2*s**2 - v*s**2 - v**2 - u*w)/(w*s**2),
        -v, -u*v + w, 0, (u**2*v*s**4 - u**2*v**2*s**2 + u**2*v**3 -
        2*v*w**2)/(w*s**2), (-u*s**2)/w, s**2, u*v*s**2/w, -v*s**2, 0,
        (-v)/s**2, (-u**3*s**2 - u*v**2 - u**2*w + w*s**2 + v*w)/w,
        s**2, 1, 0, 0, 0, 0, (-u)/w, 1, 1, -v, (-u*s**2)/w, s**2,
        s**2, -v*s**2, (-u**2*s**2 - v*s**2 - v**2 - u*w)/w,
        (-u**2*s**2 - v*s**2 - v**2 - u*w)/(w*s**2), -v, 0, 0,
        (-2*u*v*s**2 - 2*v*w)/s**2, 0, 0, 0, (-u*v**3*s**2 +
        u**2*v*w*s**2 + u*v**4 + v**2*w*s**2 - u*w**2*s**2 -
        v**3*w)/(w*s**2), (s**2 + v)/w, (u**3*v*s**4 - u**2*w*s**4 +
        u*v**4 - v**3*w + u*v*w**2)/(w**3*s**2), (u**4*s**2 +
        u**2*v*s**2 + u**2*v**2 + u**3*w - 2*u*w*s**2 - u*v*w)/w**2,
        (-u*s**2)/w, (-u)/w, 0, 0, 0, 0, (-u)/(w*s**2), 1/s**2,
        u*v/(w*s**2), (-v)/s**2, (-u)/w, 1, u*v/w, -v, (u**3*s**2 +
        2*u*v*s**2 + u*v**2 + u**2*w + v*w)/w**2, (u**3*s**2 +
        2*u*v*s**2 + u*v**2 + u**2*w + v*w)/(w**2*s**2), 1, 0, 0,
        (u*s**2 + w)/s**2, 0, (u**2*v*s**2 - u*w*s**2)/w**2,
        (-u**2*v**2*s**2 + u**2*v**3 + u*v*w*s**2 -
        v*w**2)/(w**2*s**2), 0, (u*s**2 + w)/s**2, (u**2*v**2*s**2 +
        v**3*s**2 - u*v*w*s**2 + v**4 + u*v**2*w -
        2*v*w**2)/(w**2*s**2), (-2*u**2*v**3*s**2 + u**3*v*w*s**2 +
        u*v*w*s**4 + 2*u**2*v**4 + 2*u*v**2*w*s**2 - u**2*w**2*s**2 -
        u*v**3*w - v**2*w**2)/(w**2*s**2), -v, (-v)/s**2, 0, 0, 0, 0,
        (-u)/w, u*v/w, 1, -v, (-u*s**2)/w, u*v*s**2/w, s**2, -v*s**2,
        (u**3*v*s**2 + 2*u*v**2*s**2 - u**2*w*s**2 + u*v**3 +
        2*u**2*v*w - 2*v*w*s**2 - v**2*w - 2*u*w**2)/w**2,
        (u**3*v*s**2 + 2*u*v**2*s**2 - u**2*w*s**2 + u*v**3 +
        2*u**2*v*w - 2*v*w*s**2 - v**2*w - 2*u*w**2)/(w**2*s**2),
        (-u*v**2*s**2 + u*v**3 + v*w*s**2)/(w*s**2), (-u**2*v**2*s**2
        + u**2*v**3 + u*v*w*s**2 - v*w**2)/(w*s**2), 0,
        (-2*u**3*v**3*s**2 + u**4*v*w*s**2 + u**2*v*w*s**4 +
        2*u**3*v**4 + u*v**4*s**2 - u**3*w**2*s**2 - u*v**5 -
        u**2*v**3*w - 2*v**3*w*s**2 - 3*u*v**2*w**2)/(w**2*s**2),
        (-u*s**2)/w, u*v*s**2/w, (-2*u**2*v**3*s**2 + u**3*v*w*s**2 +
        u*v*w*s**4 + 2*u**2*v**4 + 2*u*v**2*w*s**2 - u**2*w**2*s**2 -
        u*v**3*w - v**2*w**2)/(w**2*s**2), -v*s**2, 0, (-u**2*v*s**2 -
        v**2*s**2 + u*w*s**2 - v**3 + w**2)/(w**2*s**2), (-u*s**2)/w,
        1, 1/s**2, 0, 0, 0, 0, u**2/w**2, (-u)/w, (-u)/w, 1,
        u**2*s**2/w**2, (-u*s**2)/w, (-u*s**2)/w, s**2, (s**2 + v)/w,
        (s**2 + v)/(w*s**2), (-v)/s**2, 0, (-u*v**2*s**2 + u*v**3 +
        v*w*s**2 - v**2*w)/(w**2*s**2), (-u*v**3*s**2 +
        2*u**2*v*w*s**2 + u*v**4 + 2*v**2*w*s**2 +
        2*u*v*w**2)/(w**2*s**2), 0, (-u**2*v**2*s**2 + u**2*v**3 +
        u*v*w*s**2 - v*w**2)/(w**2*s**2), 0, 0, s**2, 0, 0, 0, 0, 1,
        -v, s**2, -v*s**2, 0, 0, 0, -u*v + w, 0, 0, 0, -u*v*s**2 +
        w*s**2, -v, (-v)/s**2, 0, v**2, -v, -v*s**2, (u*s**2 +
        w)/s**2, (-2*u*v*s**2 - 2*v*w)/s**2, (-2*u*v*s**2 -
        2*v*w)/s**2, (2*u*v**2*s**2 + u*v**3 + v*w*s**2 +
        2*v**2*w)/s**2, 1, 0, (-u*v**3*s**2 + u**2*v*w*s**2 + u*v**4 +
        v**2*w*s**2 - u*w**2*s**2 - v**3*w)/(w**2*s**2), 0, 0, (-u)/w,
        1, (-u*s**2)/w, s**2, 0, 0, 0, 0, 0, 0, 0, 0, u*v/w,
        u*v/(w*s**2), 0, (-u*v**2*s**2 + u*v**3 + v*w*s**2)/(w*s**2),
        (-v)/s**2, (-2*u**2*v**3*s**2 + u**3*v*w*s**2 + u*v*w*s**4 +
        2*u**2*v**4 + 2*u*v**2*w*s**2 - u**2*w**2*s**2 - u*v**3*w -
        v**2*w**2)/(w**2*s**2), (-u**2*s**2 - v*s**2 - v**2 -
        u*w)/(w*s**2), (u*s**2 + w)/s**2, (-u*v**3*s**2 +
        2*u**2*v*w*s**2 + u*v**4 + 2*v**2*w*s**2 +
        2*u*v*w**2)/(w**2*s**2), (-2*u*v*s**2 - 2*v*w)/s**2, 1,
        (u*v**3 - v**2*w)/(w**2*s**2), 0, 0, 0, 1/s**2, (-v)/s**2, 1,
        -v, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1/s**2, 0, -v, 1, u*v*s**2/w,
        (-u**2*s**2 - v*s**2 - v**2 - u*w)/(w*s**2), (u**2*v*s**2 +
        v**2*s**2 + u*w*s**2 + v**3 + 2*u*v*w)/(w*s**2), (u*s**2 +
        w)/s**2, (-2*u*v*s**2 - 2*v*w)/s**2, 1/s**2, 0, 0, 0, 0,
        (-u)/(w*s**2), 1/s**2, (-u)/w, 1, (-u*v + w)/(w**2*s**2), 0,
        0, 0, (-u*v + w)/w**2, 0, 0, 0, (-u)/w, (-u)/(w*s**2), 0,
        (-v)/s**2, u*v/(w*s**2), (-u*s**2)/w, (u**3*s**2 + u*v*s**2 +
        2*u*v**2 + u**2*w + w*s**2)/(w**2*s**2), (-u**2*s**2 - v*s**2
        - v**2 - u*w)/(w*s**2), (-u**2*s**2 - v*s**2 - v**2 -
        u*w)/(w*s**2), (u*s**2 + w)/s**2, 0, (-u**2*v*s**2 - v**2*s**2
        + u*w*s**2 - v**3 + w**2)/(w**2*s**2), (-u*s**2)/w, 1, 1/s**2,
        0, 0, 0, 0, (-u)/(w*s**2), 1/s**2, 1/s**2, (-v)/s**2, (-u)/w,
        1, 1, -v, (s**2 + v)/w, (s**2 + v)/(w*s**2), (-v)/s**2, 0, 0,
        (-u**2*s**4 + u**2*v*s**2 + v**2*s**2 + v**3 +
        u*v*w)/(w*s**2), u**2*s**2/w**2, (-u*s**2)/w, (-u*s**2)/w,
        s**2, (s**2 + v)/(w*s**2), (u**3*v*s**2 + 2*u*v**2*s**2 -
        u**2*w*s**2 + u*v**3 + u**2*v*w - v*w*s**2 -
        2*u*w**2)/(w**3*s**2), u**2*s**2/w**2, (-u)/w, (-u)/(w*s**2),
        (-u*v + w)/(w**2*s**2), 0, (-u*v + w)/w**2, 0, (-u*v**2 +
        u**2*w + v*w)/(w**3*s**2), (-u)/(w*s**2), (-u)/(w*s**2),
        1/s**2, (-u*v**2 + u**2*w + v*w)/w**3, (-u)/w, (-u)/w, 1,
        (-2*u*s**2 - 2*u*v)/w**2, (-2*u*s**2 - 2*u*v)/(w**2*s**2),
        u*v/(w*s**2), 0, (u*v**2 - v*w)/(w**2*s**2), (-u**2*s**2 -
        v*s**2 - v**2 - u*w)/(w*s**2), (-u*v**2*s**2 + 2*u*v**3 +
        v*w*s**2 - 2*v**2*w)/(w**3*s**2), 0, 0, 0, (u*s**2 + w)/s**2,
        (-u**4*v*s**4 + u**3*w*s**4 + u**2*v**3*s**2 + v**4*s**2 +
        v**5 - u**2*v*w**2 - v*w**2*s**2 - v**2*w**2 +
        u*w**3)/(v*w**2*s**2), s**2, -v, (-v)/s**2, 0, (-u*v +
        w)/s**2, 0, -u*v + w, (-u)/w, 1, u*v/w, -v, (-u*s**2)/w, s**2,
        u*v*s**2/w, -v*s**2, 0, 0, v**2/s**2, 0, 0, (u**2*v*s**4 -
        u**2*v**2*s**2 - v**3*s**2 - u*v*w*s**2 - v**4 -
        2*u*v**2*w)/(w*s**2), (-u*s**2)/w, u*v*s**2/w, s**2, -v*s**2,
        s**2, (-u*v + w)/s**2, (-u**4*v*w*s**4 + u**3*w**2*s**4 +
        u*v**5*s**2 - 3*u**2*v**3*w*s**2 + u*v*w**2*s**4 - u*v**6 +
        u**2*v**4*w - v**4*w*s**2 + 4*u*v**2*w**2*s**2 - w**3*s**4 +
        v**5*w - u*v**3*w**2 - v*w**3*s**2)/(v*w**2*s**2), 0, 0, 1,
        -v, s**2, -v*s**2, 0, 0, (-u*v + w)/s**2, (u*v**2 - v*w)/s**2,
        0, 0, -u*v + w, u*v**2 - v*w, s**2, 1, 0, (-v**3)/s**2,
        v**2/s**2, (u**3*v*s**4 - u**3*v**2*s**2 - u*v**3*s**2 -
        v*w*s**4 - u*v**4 - 2*u**2*v**2*w + v**2*w*s**2 + u*w**2*s**2
        + v**3*w + 2*u*v*w**2)/(w*s**2), (-u**2*s**4 + u**2*v*s**2 +
        v**2*s**2 + v**3 + u*v*w)/(w*s**2), (u*s**4 - u*v*s**2 -
        v*w)/s**2, (u**2*v*s**4 - u**2*v**2*s**2 - v**3*s**2 -
        u*v*w*s**2 - v**4 - 2*u*v**2*w)/(w*s**2), (-u*v*s**4 +
        2*u*v**2*s**2 + 2*v**2*w)/s**2, 0, 0, 0, 0, 0, (-u)/w, u*v/w,
        (-u*s**2)/w, u*v*s**2/w, (-u*v + w)/w**2, 0, (u*v**2*s**2 +
        u**2*v*w - v*w*s**2 - u*w**2)/(w**2*s**2), (-u*v + w)/s**2,
        (-u*v*s**2 + w*s**2)/w**2, 0, (u*v**2*s**2 + u**2*v*w -
        v*w*s**2 - u*w**2)/w**2, -u*v + w, 1, 1/s**2, 0, v**2/s**2,
        (-u*v**2)/(w*s**2), s**2, (-u**2*s**2 - v*s**2 - v**2 -
        u*w)/(w*s**2), (u**3*v*s**4 - u**3*v**2*s**2 - u**2*w*s**4 -
        2*u*v**3*s**2 + 2*u**2*v*w*s**2 - 2*u**2*v**2*w +
        2*v**2*w*s**2 + 3*u*v*w**2)/(w**2*s**2), (u**2*v*s**2 +
        v**2*s**2 + u*w*s**2 + v**3 + 2*u*v*w)/(w*s**2), (-2*u*v*s**2
        - 2*v*w)/s**2], 'U3': [0, u*v/(w*s), u*v*s/w, s, 1/s, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, (-v)/s, 0, 0, 0, 0, 0, 0, 0,
        s, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        v**2/s, (-v)/s, 0, 0, 0, 0, 0, 1/s, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, (-v)/s, u*v/(w*s), 0, 0, 0, 0,
        0, s, 0, 0, 0, 0, 1/s, (-v)/s, s, -v*s, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1/s, 0, 0, 0, 0, (-u)/(w*s),
        1/s, (-u*s)/w, s, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1/s, (-v)/s, (-v)/s,
        v**2/s, s, -v*s, -v*s, v**2*s, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, (-u)/(w*s), u*v/(w*s), 1/s, (-v)/s,
        (-u*s)/w, u*v*s/w, s, -v*s, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, (-u)/(w*s), 1/s, u*v/(w*s), (-v)/s,
        (-u*s)/w, s, u*v*s/w, -v*s, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, u**2/(w**2*s), (-u)/(w*s), (-u)/(w*s),
        1/s, u**2*s/w**2, (-u*s)/w, (-u*s)/w, s, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, -v*s, 0, (-u**2*v**2*s + u*v*w*s)/w, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, -v*s, (-v)/s, 0, 0, 0, (-v**3)/s,
        0, 0, 0, 0, s, 0, (u**2*v*s - u*w*s)/w, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, u*v*s/w, u*v/(w*s), 0, 0, 0, v**2/s, 0,
        0, 0, 0, s, 0, (u**2*v*s - u*w*s)/w, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, u*v*s/w, u*v/(w*s), 0, 0, 0, v**2/s, 0, 0,
        0, 0, (-u*s)/w, 0, (-u**3*v*s + u**2*w*s)/w**2, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, (-u**2*v*s)/w**2,
        (-u**2*v)/(w**2*s), 0, 0, 0, (-v)/s, 0, 0, 0, 0, (-v)/s,
        (-u*v**3 + v**2*w)/(w**2*s), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, (-u**2*v**2*s + 2*u*v*w*s)/w**2, (-u**2*v**2 +
        2*u*v*w)/(w**2*s), 0, 0, 0, u*v**3/(w*s), 0, 0, 0, 0, 1/s,
        (u*v**2 - v*w)/(w**2*s), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, (-u*s)/w, (-u)/(w*s), 0, 0, 0, (-u*v**2)/(w*s), 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, (-v)/s, v**2/s, v**2/s, (-v**3)/s, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        u*v/(w*s), (-v)/s, (-u*v**2)/(w*s), v**2/s, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, u*v/(w*s),
        (-u*v**2)/(w*s), (-v)/s, v**2/s, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, (-u**2*v)/(w**2*s),
        u*v/(w*s), u*v/(w*s), (-v)/s, 1/s, (u*v**2 - v*w)/(w**2*s), 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, (-u*s)/w,
        (-u)/(w*s), 0, 0, 0, (-u*v**2)/(w*s), 0, 0, 0, 0, (-u)/(w*s),
        (-u**2*v**2 + u*v*w)/(w**3*s), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, u**2*s/w**2, u**2/(w**2*s), 0, 0, 0, u*v/(w*s),
        0, 0, 0, 0, (-v)/s, (-u*v**3 + v**2*w)/(w**2*s), 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, s, 1/s, 0, 0, 0,
        u*v**3/(w*s), 0, 0, 0, 0, 0, 0, (u**3*v**2*s - 2*u**2*v*w*s +
        u*w**2*s)/(v*w), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, (u**2*v**3 - u*v**2*w)/(w*s), (-u*v**2)/(w*s),
        v**2/s, u*v**3/(w*s), (-v**3)/s, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, u*v/(w*s), (u**2*v**3 -
        2*u*v**2*w)/(w**2*s), (-u*v**2)/(w*s), v**2/s], 'U4': [1, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0], 'K4U': [0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, -v, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, (-u)/w, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -v, 1, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 1, (-u)/w, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -v*w, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, u*v, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, -v, -v, v**2, 0, (u**2*v -
        u*w)/w**2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, (-u)/w, u*v/w, u*v/w, -v, 0, 0, (u*v**2 - v*w)/w,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        (u**2*v**2 - u*v*w + w**2)/w, 0, 0, (u*v**2 - v*w)/w, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        (-u)/w, u*v/w, 1, -v, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, (u*v**2 - v*w)/w,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -u, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, u**2/w**2, (-u)/w, (-u)/w, 1, 0, (-u**3*v +
        u**2*w)/(v*w), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, u*v, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, u**2*v, -u, w, u*v, -v*w, 1,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, (u**2*v - u*w)/w, 0, 0], 'K4': [0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, u*v/s, 1/s, 0, s, 0,
        0, 0, (u*s**2 + w)/s, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, s, 1/s, 0, 0, 0, (u**2*v - v*s**2)/s, 0, 0, u*v/s, w*s, 0,
        (s**2 + v)/(w*s), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, s, v/(w*s), 0, 0, 0, 0, u/s, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, w/s, 0, w*s,
        0, 0, v*s/w, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, s, 1/s, (u*v**2 - v*w)/(w*s), v/(w*s), 0, v*s/w, 0, 0, s,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, u*w*s, 0, 0, (u*v**2 - v*w)/(w*s), 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, v*s/w, v/(w*s), s, (u*s**2 + w)/s, 0,
        (u**2*v**2 - v**2*s**2 - u*v*w + w**2)/(w*s), 1/s, s, (u*v**2
        - v*w)/(w*s), 0, 0, (-2*u*s**2 + 2*u*v)/(w*s), 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1/s, 0, 0, 0,
        0, 0, 1/s, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        1/s, 0, (s**2 + v)/(w*s), v*s/w, (v**2 - u*w)/(w**2*s),
        (-u*s**2 + u*v)/(w*s), 1/s, s, 0, u*v/s, u*v*s, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, w*s, u*w*s, 0, (u*w*s**2 +
        w**2)/s, 0, 0, 0, u**2*w*s, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, w/s, 0, 0, 0, w*s, 0, 0, 0, 0, 0, (u**2*v - v*s**2 -
        u*w)/s, 0, 0, u*s, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, s, 0, 0, (u*s**2 + w)/s, (u*s**2 +
        w)/s, (-u*v*s**2 + u*v**2 - 2*v*w)/s, 0, (-3*u*v*s**2 +
        2*u*v**2 - u**2*w + w*s**2 + v*w)/(w**2*s), (u**2*s - v*s)/w,
        0, 0, 0, 1/s, 0, s, 0, 0, v/(w*s), 0, 0, 0, v*s/w, 0, u*s/w,
        u/(w*s), 0, 0, 0, 0, (s**2 + v)/(w*s), (-v*s**2 - u*w)/(w*s),
        (-u**2*s**2 + u**2*v - v*s**2 - u*w)/(w*s), (u*s**2 + w)/s, 0,
        (v**2 - u*w)/(w*s), (-u**2*v*s**2 + 2*u**2*v**2 - v**2*s**2 +
        u*w*s**2 - 2*u*v*w + w**2)/(w*s), 0, 0, 1/s, 0, s, 0, 0, u/s,
        0, 0, 0, u*s, 0, 0, 2*u*v*s/w, 2*u*v/(w*s), u*v/s, (u**2*v -
        v*s**2)/s, s, (-u**3*v*s**2 + 2*u**3*v**2 - u*v**2*s**2 +
        u**2*w*s**2 - u*v**3 - 2*u**2*v*w - v*w*s**2 + u*w**2)/(w*s),
        0, u*s, (-u**2*v*s**2 + 2*u**2*v**2 - v**2*s**2 + u*w*s**2 -
        2*u*v*w + w**2)/(w*s), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1/(w*s),
        0, 0, 0, s/w, 0, 0, 0, 0, 0, 0, s, (-u*s**2 + u*v)/(w*s),
        (u*v**2 + w*s**2)/(w*s), (s**2 + v)/(w*s), (-u**2*s**2 +
        u**2*v - v*s**2 - u*w)/(w*s), 0, (u*s**2 + w)/s, 0, s, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, w*s, 0, 0, 0,
        0, 0, (u*w*s**2 + u*v*w)/s, 0, 0, (u*v**2 - v*w)/(w*s), 0, 0,
        0, 0, 0, 0, 0, 1/s, 0, 0, 0, s, 0, 0, v*s/w, v/(w*s), s,
        u*v/s, 0, (-u**2*v*s**2 + 2*u**2*v**2 - v**2*s**2 + u*w*s**2 -
        2*u*v*w + w**2)/(w*s), 0, 0, (u*v**2 + w*s**2)/(w*s), 0, 0,
        (-2*u*s**2 + 2*u*v)/(w*s), 0, 0, 0, 0, 0, 0, 0, 0, 0, 1/s, 0,
        0, 0, s, 0, 0, 0, 0, 0, 0, u*s, 0, v/s, 0, 0, 0, 0, 1/s, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1/s, 0, v/(w*s), 0,
        v**2/(w**2*s), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 1/s, (s**2 + v)/s, v/(w*s), 0, 0, 0,
        0, u*v/(w**2*s), v/(w*s), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, v/(w*s), 1/s, (v**2 - u*w)/(w**2*s), 0,
        (-2*u*w*s**2 + v**3 - u*v*w)/(w**3*s), (s**2 + v)/(w*s), (s**2
        + v)/(w*s), 0, 0, (u**2*v*s**2 + u**3*w + v**3 -
        3*u*v*w)/(v*w*s), 0, 0, 0, 0, 0, 0, 0, 0, 0, u/s, 0, 0, 0,
        u*s, 0, 0, 0, w/s, 0, 0, (-v*s**2 - v**2 - u*w)/s, 0, w/s, 0,
        0, 0, 0, (-u*v**3 + u**2*v*w + v**2*w - u*w**2)/(w*s), 0, 0,
        0, 0, 0, 0, 0, 0, 0, u*w/s, 0, 0, 0, u*w*s, 0, 0, 0, (-v*w)/s,
        w/s, (-u*v*s**2 - u*v**2 - u**2*w + v*w)/s, (s**2 + v)/s, 0,
        (-v*s**2 - v**2 - u*w)/s, (u*w*s**2 + w**2)/s, 0, 0, 0, s,
        1/s, 0, u/s, 0, u*s, 0, 0, u*v/(w*s), 0, 0, 0, u*v*s/w, 0, 0,
        0, 0, w/s, (-u)/s, 0, 0, (-2*u*v*s**2 - u**2*w + w*s**2 +
        v*w)/(w*s), v/s, 0], 'K6': [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -u, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -u**2,
        0, 0, -u, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, (-u*v +
        w)/w, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, (-u*v + w)/w, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, (-u**2*v +
        u*w)/w, 0, 0, (-u*v + w)/w, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        (-u)/w, 0, 0, 0, -u, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -u**2, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, -u*v + w, 0, u*v/w**2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, v/w, (-u**2)/w, 0, 0, 0,
        (-2*u**2*v + u*w)/w, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, -u, -u**2, 0, (-2*u**3*v + u*v**2 + u**2*w)/w, 0, 0,
        (-2*u**2*v + u*w)/w, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, (-u)/w, (-u*v)/w, 0, (-u**2)/w, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, -u*w, 0, 0, (-u*v + w)/w, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -u, 0, (-2*u**2*v + u*w)/w, 0,
        0, (-u*v)/w, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        1/w, 0, 0, 0, 0, 0, 1/w, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, (-u)/w**2, 0, 0, 0, 0, (-u**2*v +
        u*w)/(v*w), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 1, v, 0, u, 0, 0, 0, 0, (u*v**3 - u**2*v*w - v**2*w +
        u*w**2)/(v*w), 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, w, 0, u*v, 0, 0, v, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 1, 0, v/w, 0, 0, u*v/w, 0, 0], 'K7': [0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        1/w, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, u/w, 0, 0, 1/w, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, v/w**2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        v/w**2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, u*v/w**2, 0, 0, v/w**2, 0, 0, 1/w**2, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        1/w**2, 0, 0, 0, 1/w, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, u/w, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, v/w, 0, v/w**3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, u/w**2, 0, 0, 0, 2*u*v/w**2,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1/w, u/w, 0,
        (2*u**2*v - v**2)/w**2, 0, 0, 2*u*v/w**2, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1/w**2, v/w**2,
        0, u/w**2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, v/w**2, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1/w, 0, 2*u*v/w**2, 0,
        0, v/w**2, 0, 0, 1/w**2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 1/w**3, 0, 0, 0, 0, (-1)/(v*w), 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, (-v**2 + u*w)/w**2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, v/w**2, 0, 0],
        'K91': [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, w**2/v, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0], 'K92': [0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, w/v, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
        0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0]}
    return data[num_strands][bas_ele]

