import * as cdk from '@aws-cdk/core';
import * as iam from '@aws-cdk/aws-iam';
import { Network } from './network';
export interface IamRolesProps {
    readonly s3InstallBucketName: string;
    readonly network: Network;
}
/**
 * Create all required IAM roles
 */
export declare class IamRoles extends cdk.Construct {
    readonly computeNodeIamRole: iam.IRole;
    readonly schedulerIAMRole: iam.IRole;
    readonly computeNodeInstanceProfileName: string;
    readonly schedulerIamInstanceProfileName: string;
    constructor(scope: cdk.Construct, id: string, props: IamRolesProps);
}
