import * as cdk from '@aws-cdk/core';
import { InstanceType } from '@aws-cdk/aws-ec2';
import { BaseOS } from './scheduler';
export interface WorkloadProps {
    /**
     * S3 bucket with your SOCA installer.
     * Name of your S3 Bucket where you uploaded your install files.
     * @default - solutions-reference
     */
    readonly s3InstallBucket?: string;
    /**
     * Name of the S3 folder where you uploaded SOCA
     * @default - scale-out-computing-on-aws/v2.5.0
     */
    readonly s3InstallFolder?: string;
    /**
     * Linux distribution
     * @default - amazonlinux2
     */
    readonly linuxDistribution?: BaseOS;
    /**
     * Custom AMI if available
     * @default - no custom AMI
     */
    readonly customAmi?: string;
    /**
     * Instance type for your master host(scheduler)
     * @default - m5.xlarge
     */
    readonly instanceType?: InstanceType;
    /**
     * VPC Cidr for the new VPC
     * @default - 10.0.0.0/16
     */
    readonly vpcCidr?: string;
    /**
     * Default IP(s) allowed to directly SSH into the scheduler and access ElasticSearch. 0.0.0.0/0 means
     * ALL INTERNET access. You probably want to change it with your own IP/subnet (x.x.x.x/32 for your own
     * ip or x.x.x.x/24 for range. Replace x.x.x.x with your own PUBLIC IP. You can get your public IP using
     * tools such as https://ifconfig.co/). Make sure to keep it restrictive!
     *
     * @default - not to add any client IP Cidr address
     */
    readonly clientIpCidr?: string;
    /**
     * Default SSH pem keys used to SSH into the scheduler
     */
    readonly sshKeyName?: string;
    /**
     * Username for your default LDAP user
     *
     * @default - 'ldapUserName'
     */
    readonly ldapUserName?: string;
    /**
     * Password for your default LDAP user
     *
     * @default - 'ldapUserPassword!123'
     */
    readonly ldapUserPassword?: string;
}
export declare class Workload extends cdk.Construct {
    constructor(scope: cdk.Construct, id: string, props?: WorkloadProps);
}
