import * as cdk from '@aws-cdk/core';
import * as ec2 from '@aws-cdk/aws-ec2';
import { Network } from './network';
import { EfsStorage } from './storage';
export declare enum BaseOS {
    CENTOS_7 = "centos7",
    RHEL_7 = "rhel7",
    AMZN2 = "amazonlinux2"
}
export interface SchedulerProps {
    readonly customAmi?: string;
    readonly baseOs?: BaseOS;
    readonly network: Network;
    readonly instanceType?: ec2.InstanceType;
    readonly s3InstallBucket: string;
    readonly s3InstallFolder: string;
    readonly ldapUserName: string;
    readonly ldapUserPassword: string;
    readonly schedulerSecurityGroup: ec2.ISecurityGroup;
    readonly storage: EfsStorage;
}
export declare class Scheduler extends cdk.Construct {
    constructor(scope: cdk.Construct, id: string, props: SchedulerProps);
}
