"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EfsStorage = void 0;
const cdk = require("@aws-cdk/core");
const ec2 = require("@aws-cdk/aws-ec2");
const efs = require("@aws-cdk/aws-efs");
class EfsStorage extends cdk.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const region = cdk.Stack.of(this).region;
        const urlsuffix = cdk.Stack.of(this).urlSuffix;
        const efsApps = new efs.FileSystem(this, 'EFSApps', {
            vpc: props.vpc,
            encrypted: true,
            throughputMode: efs.ThroughputMode.BURSTING,
            removalPolicy: cdk.RemovalPolicy.DESTROY,
            vpcSubnets: {
                subnetType: ec2.SubnetType.PRIVATE,
            },
            securityGroup: props.computeNodeSecurityGroup,
        });
        efsApps.connections.addSecurityGroup(props.schedulerSecurityGroup);
        const efsData = new efs.FileSystem(this, 'EFSData', {
            vpc: props.vpc,
            encrypted: true,
            throughputMode: efs.ThroughputMode.BURSTING,
            removalPolicy: cdk.RemovalPolicy.DESTROY,
            vpcSubnets: {
                subnetType: ec2.SubnetType.PRIVATE,
            },
            securityGroup: props.computeNodeSecurityGroup,
        });
        efsData.connections.addSecurityGroup(props.schedulerSecurityGroup);
        this.efsDataDns = `${efsData.fileSystemId}.efs.${region}.${urlsuffix}`;
        this.efsAppsDns = `${efsApps.fileSystemId}.efs.${region}.${urlsuffix}`;
        new cdk.CfnOutput(this, 'EFSAppsOutput', { value: efsApps.fileSystemId });
        new cdk.CfnOutput(this, 'EFSDataOutput', { value: efsData.fileSystemId });
        new cdk.CfnOutput(this, 'EFSAppsDnsOutput', { value: this.efsAppsDns });
        new cdk.CfnOutput(this, 'EFSDataDnsOutput', { value: this.efsDataDns });
        new cdk.CfnOutput(this, 'EFSMountParametersOutput', {
            value: 'nfsvers=4.1,rsize=1048576,wsize=1048576,hard,timeo=600,retrans=2,noresvport',
        });
    }
}
exports.EfsStorage = EfsStorage;
//# sourceMappingURL=data:application/json;base64,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