# -*- coding: utf-8 -*-
# Generated by Django 1.10.2 on 2018-02-15 14:22
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='LDAP',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('action', models.TextField()),
                ('succeeded', models.NullBooleanField()),
                ('errorMessage', models.TextField(blank=True, null=True)),
                ('basedn', models.TextField(blank=True, null=True)),
                ('entry', models.TextField(blank=True, null=True)),
                ('objectClass', models.TextField(blank=True, null=True)),
                ('cn', models.TextField(blank=True, null=True)),
                ('existing_members', models.TextField(blank=True, null=True)),
                ('data_members', models.TextField(blank=True, null=True)),
                ('diff_members', models.TextField(blank=True, null=True)),
            ],
            options={
                'verbose_name': 'LDAP event log entry',
                'verbose_name_plural': 'LDAP event log entries',
            },
        ),
        migrations.CreateModel(
            name='Model',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('message', models.TextField(null=True)),
                ('action', models.PositiveSmallIntegerField(choices=[(0, 'n/a'), (1, 'add'), (2, 'change'), (3, 'delete')], default=0)),
                ('application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='atl_model_application', to='contenttypes.ContentType')),
            ],
            options={
                'verbose_name': 'model log entry',
                'verbose_name_plural': 'model log entries',
            },
        ),
        migrations.CreateModel(
            name='ModelChangelog',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'verbose_name': 'Model entry change',
                'verbose_name_plural': 'Model entry changes',
            },
        ),
        migrations.CreateModel(
            name='ModelModification',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ModelObject',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('value', models.CharField(max_length=255)),
                ('model', models.CharField(max_length=255)),
                ('application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='atl_modelobject_application', to='contenttypes.ContentType')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Request',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('url', models.URLField()),
                ('application', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='contenttypes.ContentType')),
                ('user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'request event entry',
                'verbose_name_plural': 'request event entries',
            },
        ),
        migrations.CreateModel(
            name='Unspecified',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('message', models.TextField(null=True)),
                ('level', models.PositiveSmallIntegerField(default=20)),
                ('file', models.CharField(max_length=255, null=True)),
                ('line', models.PositiveIntegerField(null=True)),
            ],
            options={
                'verbose_name': ' logging entry (Errors, Warnings, Info)',
                'verbose_name_plural': ' logging entries (Errors, Warnings, Info)',
            },
        ),
        migrations.AddField(
            model_name='modelmodification',
            name='currently',
            field=models.ManyToManyField(related_name='changelog_current', to='automated_logging.ModelObject'),
        ),
        migrations.AddField(
            model_name='modelmodification',
            name='previously',
            field=models.ManyToManyField(related_name='changelog_previous', to='automated_logging.ModelObject'),
        ),
        migrations.AddField(
            model_name='modelchangelog',
            name='information',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='automated_logging.ModelObject'),
        ),
        migrations.AddField(
            model_name='modelchangelog',
            name='inserted',
            field=models.ManyToManyField(related_name='changelog_inserted', to='automated_logging.ModelObject'),
        ),
        migrations.AddField(
            model_name='modelchangelog',
            name='modification',
            field=models.OneToOneField(null=True, on_delete=django.db.models.deletion.CASCADE, to='automated_logging.ModelModification'),
        ),
        migrations.AddField(
            model_name='modelchangelog',
            name='removed',
            field=models.ManyToManyField(related_name='changelog_removed', to='automated_logging.ModelObject'),
        ),
        migrations.AddField(
            model_name='model',
            name='information',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='atl_model_information', to='automated_logging.ModelObject'),
        ),
        migrations.AddField(
            model_name='model',
            name='modification',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='automated_logging.ModelChangelog'),
        ),
        migrations.AddField(
            model_name='model',
            name='user',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL),
        ),
    ]
