import * as iot from '@aws-cdk/aws-iot-alpha';
import { CommonActionProps } from './common-action-props';
/**
 * (experimental) Configuration properties of an action for CloudWatch metric.
 *
 * @experimental
 */
export interface CloudWatchPutMetricActionProps extends CommonActionProps {
    /**
     * (experimental) The CloudWatch metric name.
     *
     * Supports substitution templates.
     *
     * @see https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html
     * @experimental
     */
    readonly metricName: string;
    /**
     * (experimental) The CloudWatch metric namespace name.
     *
     * Supports substitution templates.
     *
     * @see https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html
     * @experimental
     */
    readonly metricNamespace: string;
    /**
     * (experimental) A string that contains the timestamp, expressed in seconds in Unix epoch time.
     *
     * Supports substitution templates.
     *
     * @default - none -- Defaults to the current Unix epoch time.
     * @see https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html
     * @experimental
     */
    readonly metricTimestamp?: string;
    /**
     * (experimental) The metric unit supported by CloudWatch.
     *
     * Supports substitution templates.
     *
     * @see https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html
     * @experimental
     */
    readonly metricUnit: string;
    /**
     * (experimental) A string that contains the CloudWatch metric value.
     *
     * Supports substitution templates.
     *
     * @see https://docs.aws.amazon.com/iot/latest/developerguide/iot-substitution-templates.html
     * @experimental
     */
    readonly metricValue: string;
}
/**
 * (experimental) The action to capture an Amazon CloudWatch metric.
 *
 * @experimental
 */
export declare class CloudWatchPutMetricAction implements iot.IAction {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: CloudWatchPutMetricActionProps);
    /**
     * (experimental) (experimental) Returns the topic rule action specification.
     *
     * @experimental
     */
    bind(rule: iot.ITopicRule): iot.ActionConfig;
}
