import * as iot from '@aws-cdk/aws-iot-alpha';
import * as firehose from '@aws-cdk/aws-kinesisfirehose-alpha';
import { CommonActionProps } from './common-action-props';
/**
 * (experimental) Record Separator to be used to separate records.
 *
 * @experimental
 */
export declare enum FirehoseStreamRecordSeparator {
    /**
     * (experimental) Separate by a new line.
     *
     * @experimental
     */
    NEWLINE = "\n",
    /**
     * (experimental) Separate by a tab.
     *
     * @experimental
     */
    TAB = "\t",
    /**
     * (experimental) Separate by a windows new line.
     *
     * @experimental
     */
    WINDOWS_NEWLINE = "\r\n",
    /**
     * (experimental) Separate by a commma.
     *
     * @experimental
     */
    COMMA = ","
}
/**
 * (experimental) Configuration properties of an action for the Kinesis Data Firehose stream.
 *
 * @experimental
 */
export interface FirehoseStreamActionProps extends CommonActionProps {
    /**
     * (experimental) Whether to deliver the Kinesis Data Firehose stream as a batch by using `PutRecordBatch`.
     *
     * When batchMode is true and the rule's SQL statement evaluates to an Array, each Array
     * element forms one record in the PutRecordBatch request. The resulting array can't have
     * more than 500 records.
     *
     * @default false
     * @experimental
     */
    readonly batchMode?: boolean;
    /**
     * (experimental) A character separator that will be used to separate records written to the Kinesis Data Firehose stream.
     *
     * @default - none -- the stream does not use a separator
     * @experimental
     */
    readonly recordSeparator?: FirehoseStreamRecordSeparator;
}
/**
 * (experimental) The action to put the record from an MQTT message to the Kinesis Data Firehose stream.
 *
 * @experimental
 */
export declare class FirehoseStreamAction implements iot.IAction {
    private readonly stream;
    private readonly batchMode?;
    private readonly recordSeparator?;
    private readonly role?;
    /**
     * @param stream The Kinesis Data Firehose stream to which to put records.
     * @param props Optional properties to not use default.
     * @experimental
     */
    constructor(stream: firehose.IDeliveryStream, props?: FirehoseStreamActionProps);
    /**
     * (experimental) (experimental) Returns the topic rule action specification.
     *
     * @experimental
     */
    bind(rule: iot.ITopicRule): iot.ActionConfig;
}
