"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaFunctionAction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * (experimental) The action to invoke an AWS Lambda function, passing in an MQTT message.
 *
 * @experimental
 */
class LambdaFunctionAction {
    /**
     * @param func The lambda function to be invoked by this action.
     * @experimental
     */
    constructor(func) {
        this.func = func;
    }
    /**
     * (experimental) (experimental) Returns the topic rule action specification.
     *
     * @experimental
     */
    bind(topicRule) {
        this.func.addPermission(`${aws_cdk_lib_1.Names.nodeUniqueId(topicRule.node)}:IotLambdaFunctionAction`, {
            action: 'lambda:InvokeFunction',
            principal: new iam.ServicePrincipal('iot.amazonaws.com'),
            sourceAccount: topicRule.env.account,
            sourceArn: topicRule.topicRuleArn,
        });
        return {
            configuration: {
                lambda: {
                    functionArn: this.func.functionArn,
                },
            },
        };
    }
}
exports.LambdaFunctionAction = LambdaFunctionAction;
_a = JSII_RTTI_SYMBOL_1;
LambdaFunctionAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.LambdaFunctionAction", version: "2.1.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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