# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/07_web.ipynb (unless otherwise specified).

__all__ = ['array2png']

# Cell
import PIL
import matplotlib
import numpy as np

# Cell
def array2png(data, cmap='RdYlGn_r'):
    "Convert uint8 2d-array 'data' to png using colormap 'cmap'"
    mask = data == 0
    unique = sorted(np.unique(data[data>0]).reshape(-1).tolist())
    cmap = matplotlib.cm.get_cmap(cmap)
    colors = (cmap(np.linspace(0,1,unique[-1]-unique[0]+1))*255).astype(np.uint8)
    data[data>0] -= unique[0]
    data = data.astype(np.uint8)
    data = colors[data]
    data[mask, -1] = 0
    return PIL.Image.fromarray(data)