# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.pipeline import ClientRawResponse
from msrest.exceptions import HttpOperationError

from .. import models


class HttpRuntimeOperations(object):
    """HttpRuntimeOperations operations.

    :param client: Client for service requests.
    :param config: Configuration of service client.
    :param serializer: An object model serializer.
    :param deserializer: An object model deserializer.
    :ivar api_version: The API version to use for the request. Constant value: "2020-05-31-preview".
    """

    models = models

    def __init__(self, client, config, serializer, deserializer):

        self._client = client
        self._serialize = serializer
        self._deserialize = deserializer

        self.config = config
        self.api_version = "2020-05-31-preview"

    def receive_feedback_notification(self, custom_headers=None, raw=False, **operation_config):
        """This method is used to retrieve feedback of a cloud-to-device message.

        This method is used to retrieve feedback of a cloud-to-device message
        See https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging
        for more information. This capability is only available in the standard
        tier IoT Hub. For more information, see [Choose the right IoT Hub
        tier](https://aka.ms/scaleyouriotsolution).

        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.receive_feedback_notification.metadata["url"]

        # Construct parameters
        query_parameters = {}
        query_parameters["api-version"] = self._serialize.query(
            "self.api_version", self.api_version, "str"
        )

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.get(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [200, 204]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    receive_feedback_notification.metadata = {"url": "/messages/serviceBound/feedback"}

    def complete_feedback_notification(
        self, lock_token, custom_headers=None, raw=False, **operation_config
    ):
        """This method completes a feedback message.

        This method completes a feedback message. The lockToken obtained when
        the message was received must be provided to resolve race conditions
        when completing, a feedback message. A completed message is deleted
        from the feedback queue. See
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging for
        more information.

        :param lock_token: Lock token.
        :type lock_token: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.complete_feedback_notification.metadata["url"]
        path_format_arguments = {"lockToken": self._serialize.url("lock_token", lock_token, "str")}
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters["api-version"] = self._serialize.query(
            "self.api_version", self.api_version, "str"
        )

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.delete(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    complete_feedback_notification.metadata = {"url": "/messages/serviceBound/feedback/{lockToken}"}

    def abandon_feedback_notification(
        self, lock_token, custom_headers=None, raw=False, **operation_config
    ):
        """This method abandons a feedback message.

        This method abandons a feedback message. The lockToken obtained when
        the message was received must be provided to resolve race conditions
        when abandoning, a feedback message. A abandoned message is deleted
        from the feedback queue. See
        https://docs.microsoft.com/azure/iot-hub/iot-hub-devguide-messaging for
        more information.

        :param lock_token: Lock Token.
        :type lock_token: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: None or ClientRawResponse if raw=true
        :rtype: None or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`HttpOperationError<msrest.exceptions.HttpOperationError>`
        """
        # Construct URL
        url = self.abandon_feedback_notification.metadata["url"]
        path_format_arguments = {"lockToken": self._serialize.url("lock_token", lock_token, "str")}
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}
        query_parameters["api-version"] = self._serialize.query(
            "self.api_version", self.api_version, "str"
        )

        # Construct headers
        header_parameters = {}
        if custom_headers:
            header_parameters.update(custom_headers)

        # Construct and send request
        request = self._client.post(url, query_parameters, header_parameters)
        response = self._client.send(request, stream=False, **operation_config)

        if response.status_code not in [204]:
            raise HttpOperationError(self._deserialize, response)

        if raw:
            client_raw_response = ClientRawResponse(None, response)
            return client_raw_response

    abandon_feedback_notification.metadata = {
        "url": "/messages/serviceBound/feedback/{lockToken}/abandon"
    }
