# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dnacentersdk',
 'dnacentersdk.api',
 'dnacentersdk.api.v1_2_10',
 'dnacentersdk.api.v1_3_0',
 'dnacentersdk.api.v1_3_1',
 'dnacentersdk.api.v1_3_3',
 'dnacentersdk.api.v2_1_1',
 'dnacentersdk.api.v2_1_2',
 'dnacentersdk.api.v2_2_1',
 'dnacentersdk.models',
 'dnacentersdk.models.validators',
 'dnacentersdk.models.validators.v1_2_10',
 'dnacentersdk.models.validators.v1_3_0',
 'dnacentersdk.models.validators.v1_3_1',
 'dnacentersdk.models.validators.v1_3_3',
 'dnacentersdk.models.validators.v2_1_1',
 'dnacentersdk.models.validators.v2_1_2',
 'dnacentersdk.models.validators.v2_2_1']

package_data = \
{'': ['*']}

install_requires = \
['fastjsonschema>=2.14.5,<3.0.0',
 'future>=0.18.2,<0.19.0',
 'requests-toolbelt>=0.9.1,<0.10.0',
 'requests>=2.24.0,<3.0.0']

setup_kwargs = {
    'name': 'dnacentersdk',
    'version': '2.2.2',
    'description': 'Cisco DNA Center Platform SDK',
    'long_description': '=============\ndnacentersdk\n=============\n\n*Work with the DNA Center APIs in native Python!*\n\n-------------------------------------------------------------------------------\n\n**dnacentersdk** is a *community developed* Python library for working with the DNA Center APIs.  Our goal is to make working with DNA Center in Python a *native* and *natural* experience!\n\n.. code-block:: python\n\n    from dnacentersdk import api\n\n    # Create a DNACenterAPI connection object;\n    # it uses DNA Center sandbox URL, username and password, with DNA Center API version 2.1.2.\n    # and requests to verify the server\'s TLS certificate with verify=True.\n    dnac = api.DNACenterAPI(username="devnetuser",\n                            password="Cisco123!",\n                            base_url="https://sandboxdnac.cisco.com:443",\n                            version=\'2.1.2\',\n                            verify=True)\n\n    # Find all devices that have \'Switches and Hubs\' in their family\n    devices = dnac.devices.get_device_list(family=\'Switches and Hubs\')\n\n    # Print all of demo devices\n    for device in devices.response:\n        print(\'{:20s}{}\'.format(device.hostname, device.upTime))\n\n    # Find all tags\n    all_tags = dnac.tag.get_tag(sort_by=\'name\', order=\'des\')\n    demo_tags = [tag for tag in all_tags.response if \'Demo\' in tag.name ]\n\n    #  Delete all of the demo tags\n    for tag in demo_tags:\n        dnac.tag.delete_tag(tag.id)\n    \n    # Create a new demo tag\n    demo_tag = dnac.tag.create_tag(name=\'dna Demo\')\n    task_demo_tag = dnac.task.get_task_by_id(task_id=demo_tag.response.taskId)\n\n    if not task_demo_tag.response.isError:\n        # Retrieve created tag\n        created_tag = dnac.tag.get_tag(name=\'dna Demo\')\n\n        # Update tag\n        update_tag = dnac.tag.update_tag(id=created_tag.response[0].id, \n                                         name=\'Updated \' + created_tag.response[0].name,\n                                         description=\'DNA demo tag\')\n        \n        print(dnac.task.get_task_by_id(task_id=update_tag.response.taskId).response.progress)\n        \n        # Retrieved updated\n        updated_tag = dnac.tag.get_tag(name=\'Updated dna Demo\')\n        print(updated_tag)\n    else:\n        # Get task error details \n        print(\'Unfortunately \', task_demo_tag.response.progress)\n        print(\'Reason: \', task_demo_tag.response.failureReason)\n\n    # Advance usage example using Custom Caller functions\n    # Define the get_global_credentials and create_netconf_credentials functions\n    # under the custom_caller wrapper.\n    # Call them with:\n    #     dnac.custom_caller.get_global_credentials(\'NETCONF\')\n    #     dnac.custom_caller.create_netconf_credentials(\'65533\')\n    def setup_custom():\n        dnac.custom_caller.add_api(\'get_global_credentials\',\n                                lambda credential_type:\n                                    dnac.custom_caller.call_api(\n                                        \'GET\',\n                                        \'/dna/intent/api/v1/global-credential\',\n                                        params={\n                                            \'credentialSubType\': credential_type\n                                        }).response\n                                )\n        dnac.custom_caller.add_api(\'create_netconf_credentials\',\n                                lambda port:\n                                    dnac.custom_caller.call_api(\n                                        \'POST\',\n                                        \'/dna/intent/api/v1/global-credential/netconf\',\n                                        json=[{\n                                            "netconfPort": port\n                                        }])\n                                )\n\n    # Add the custom API calls to the connection object under the custom_caller wrapper\n    setup_custom()\n    # Call the newly added functions\n    dnac.custom_caller.create_netconf_credentials(\'65533\')\n    print(dnac.custom_caller.get_global_credentials(\'NETCONF\'))\n\n\nIntroduction_\n\n\nInstallation\n------------\n\nInstalling and upgrading dnacentersdk is easy:\n\n**Install via PIP**\n\n.. code-block:: bash\n\n    $ pip install dnacentersdk\n\n**Upgrading to the latest Version**\n\n.. code-block:: bash\n\n    $ pip install dnacentersdk --upgrade\n\n\nDocumentation\n-------------\n\n**Excellent documentation is now available at:**\nhttps://dnacentersdk.readthedocs.io\n\nCheck out the Quickstart_ to dive in and begin using dnacentersdk.\n\n\nRelease Notes\n-------------\n\nPlease see the releases_ page for release notes on the incremental functionality and bug fixes incorporated into the published releases.\n\n\nQuestions, Support & Discussion\n-------------------------------\n\ndnacentersdk is a *community developed* and *community supported* project.  If you experience any issues using this package, please report them using the issues_ page.\n\n\nContribution\n------------\n\ndnacentersdk_ is a community development projects.  Feedback, thoughts, ideas, and code contributions are welcome!  Please see the `Contributing`_ guide for more information.\n\n\nInspiration\n------------\n\nThis library is inspired by the webexteamssdk_  library\n\n\n*Copyright (c) 2019-2020 Cisco and/or its affiliates.*\n\n.. _Introduction: https://dnacentersdk.readthedocs.io/en/latest/api/intro.html\n.. _dnacentersdk.readthedocs.io: https://dnacentersdk.readthedocs.io\n.. _Quickstart: https://dnacentersdk.readthedocs.io/en/latest/api/quickstart.html\n.. _dnacentersdk: https://github.com/cisco-en-programmability/dnacentersdk\n.. _issues: https://github.com/cisco-en-programmability/dnacentersdk/issues\n.. _pull requests: https://github.com/cisco-en-programmability/dnacentersdk/pulls\n.. _releases: https://github.com/cisco-en-programmability/dnacentersdk/releases\n.. _the repository: dnacentersdk_\n.. _pull request: `pull requests`_\n.. _Contributing: https://github.com/cisco-en-programmability/dnacentersdk/blob/master/docs/contributing.rst\n.. _webexteamssdk: https://github.com/CiscoDevNet/webexteamssdk\n\n',
    'author': 'Jose Bogarin Solano',
    'author_email': 'jbogarin@altus.cr',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://dnacentersdk.readthedocs.io/en/latest/',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.5,<4.0',
}


setup(**setup_kwargs)
