# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['Webhook']


class Webhook(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 concurrency: Optional[pulumi.Input[int]] = None,
                 instance_id: Optional[pulumi.Input[int]] = None,
                 queue: Optional[pulumi.Input[str]] = None,
                 retry_interval: Optional[pulumi.Input[int]] = None,
                 vhost: Optional[pulumi.Input[str]] = None,
                 webhook_uri: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        This resource allows you to enable or disable webhooks for a specific vhost and queue.

        Only available for dedicated subscription plans.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_cloudamqp as cloudamqp

        webhook_queue = cloudamqp.Webhook("webhookQueue",
            instance_id=cloudamqp_instance["instance"]["id"],
            vhost="myvhost",
            queue="webhook-queue",
            webhook_uri="https://example.com/webhook?key=secret",
            retry_interval=5,
            concurrency=5)
        ```
        ## Dependency

        This resource depends on CloudAMQP instance identifier, `cloudamqp_instance.instance.id`.

        ## Import

        `cloudamqp_webhook` can be imported using the resource identifier together with CloudAMQP instance identifier. The identifiers are CSV separated, see example below.

        ```sh
         $ pulumi import cloudamqp:index/webhook:Webhook webhook_queue <webhook_id>,<instance_id>`
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] concurrency: Max simultaneous requests to the endpoint.
        :param pulumi.Input[int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[str] queue: A (durable) queue on your RabbitMQ instance.
        :param pulumi.Input[int] retry_interval: How often we retry if your endpoint fails (in seconds).
        :param pulumi.Input[str] vhost: The vhost the queue resides in.
        :param pulumi.Input[str] webhook_uri: A POST request will be made for each message in the queue to this endpoint.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if concurrency is None:
                raise TypeError("Missing required property 'concurrency'")
            __props__['concurrency'] = concurrency
            if instance_id is None:
                raise TypeError("Missing required property 'instance_id'")
            __props__['instance_id'] = instance_id
            if queue is None:
                raise TypeError("Missing required property 'queue'")
            __props__['queue'] = queue
            if retry_interval is None:
                raise TypeError("Missing required property 'retry_interval'")
            __props__['retry_interval'] = retry_interval
            if vhost is None:
                raise TypeError("Missing required property 'vhost'")
            __props__['vhost'] = vhost
            if webhook_uri is None:
                raise TypeError("Missing required property 'webhook_uri'")
            __props__['webhook_uri'] = webhook_uri
        super(Webhook, __self__).__init__(
            'cloudamqp:index/webhook:Webhook',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            concurrency: Optional[pulumi.Input[int]] = None,
            instance_id: Optional[pulumi.Input[int]] = None,
            queue: Optional[pulumi.Input[str]] = None,
            retry_interval: Optional[pulumi.Input[int]] = None,
            vhost: Optional[pulumi.Input[str]] = None,
            webhook_uri: Optional[pulumi.Input[str]] = None) -> 'Webhook':
        """
        Get an existing Webhook resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] concurrency: Max simultaneous requests to the endpoint.
        :param pulumi.Input[int] instance_id: The CloudAMQP instance ID.
        :param pulumi.Input[str] queue: A (durable) queue on your RabbitMQ instance.
        :param pulumi.Input[int] retry_interval: How often we retry if your endpoint fails (in seconds).
        :param pulumi.Input[str] vhost: The vhost the queue resides in.
        :param pulumi.Input[str] webhook_uri: A POST request will be made for each message in the queue to this endpoint.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["concurrency"] = concurrency
        __props__["instance_id"] = instance_id
        __props__["queue"] = queue
        __props__["retry_interval"] = retry_interval
        __props__["vhost"] = vhost
        __props__["webhook_uri"] = webhook_uri
        return Webhook(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def concurrency(self) -> pulumi.Output[int]:
        """
        Max simultaneous requests to the endpoint.
        """
        return pulumi.get(self, "concurrency")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[int]:
        """
        The CloudAMQP instance ID.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def queue(self) -> pulumi.Output[str]:
        """
        A (durable) queue on your RabbitMQ instance.
        """
        return pulumi.get(self, "queue")

    @property
    @pulumi.getter(name="retryInterval")
    def retry_interval(self) -> pulumi.Output[int]:
        """
        How often we retry if your endpoint fails (in seconds).
        """
        return pulumi.get(self, "retry_interval")

    @property
    @pulumi.getter
    def vhost(self) -> pulumi.Output[str]:
        """
        The vhost the queue resides in.
        """
        return pulumi.get(self, "vhost")

    @property
    @pulumi.getter(name="webhookUri")
    def webhook_uri(self) -> pulumi.Output[str]:
        """
        A POST request will be made for each message in the queue to this endpoint.
        """
        return pulumi.get(self, "webhook_uri")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

