# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['wiktionary_de_parser', 'wiktionary_de_parser.methods']

package_data = \
{'': ['*'], 'wiktionary_de_parser': ['assets/*']}

install_requires = \
['lxml>=4.6.4,<5.0.0', 'pyphen>=0.11.0,<0.12.0']

setup_kwargs = {
    'name': 'wiktionary-de-parser',
    'version': '0.8.3',
    'description': 'Extracts data from German Wiktionary dump files. Allows you to add your own extraction methods 🚀',
    'long_description': '# wiktionary_de_parser\n\n`wiktionary_de_parser` is a Python module to extract data from German Wiktionary XML files (for Python 3.7+). It allows you to add your own extraction methods.\n\n## Installation\n\n`pip3 install wiktionary_de_parser`\n\n## Features\n\n- comes with preset extraction methods for:\n  - flexion tables, genus, IPA, language, lemma, part of speech (basic), syllables, raw Wikitext\n- allows you to add your own extraction methods (pass them as argument)\n- data values are normalized and cleaned from obsolete Wikitext markup\n- yields per section, not per page (a word can have multiple meanings, which is why some Wiktionary pages have multiple \'sections\')\n\n## Usage\n\nImport `wiktionary_de_parser` like this:\n\n```python\nfrom bz2 import BZ2File\nfrom wiktionary_de_parser import Parser\n\nbzfile_path = \'/tmp/dewiktionary-latest-pages-articles-multistream.xml.bz2\'\nbz = BZ2File(bzfile_path)\n\nfor record in Parser(bz):\n    if \'lang_code\' not in record or record[\'lang_code\'] != \'de\':\n      continue\n    # do stuff with \'record\'\n```\n\nNote: in this example we use [BZ2File](https://pypi.org/project/bz2file/) to read a compressed Wiktionary dump file.\nThe Wiktionary dump file is obtained from [here](https://dumps.wikimedia.org/dewiktionary/).\n\n### Adding new extraction methods\n\nAll extraction methods must return a `Dict()` and accept the following arguments:\n\n- `title` (_string_): The title of the current Wiktionary page\n- `text` (_string_): The [Wikitext](https://en.wikipedia.org/wiki/Wiki#Editing) of the current word entry/section\n- `current_record` (_Dict_): A dictionary with all values of the current iteration (e. g. `current_record[\'lang_code\']`)\n\n```python\n# Create a new extraction method\ndef my_method(title, text, current_record):\n  # do stuff\n  return {\'my_field\': my_data}\n\n# Pass a list with all extraction methods to the class constructor:\nfor record in Parser(bz, custom_methods=[my_method]):\n    print(record[\'my_field\'])\n```\n\n## Sample data:\n\n```python\n{\'flexion\': {\'Akkusativ Plural\': \'Trittbrettfahrer\',\n             \'Akkusativ Singular\': \'Trittbrettfahrer\',\n             \'Dativ Plural\': \'Trittbrettfahrern\',\n             \'Dativ Singular\': \'Trittbrettfahrer\',\n             \'Genitiv Plural\': \'Trittbrettfahrer\',\n             \'Genitiv Singular\': \'Trittbrettfahrers\',\n             \'Genus\': \'m\',\n             \'Nominativ Plural\': \'Trittbrettfahrer\',\n             \'Nominativ Singular\': \'Trittbrettfahrer\'},\n \'inflected\': False,\n \'ipa\': [\'ˈtʁɪtbʁɛtˌfaːʁɐ\'],\n \'lang\': \'Deutsch\',\n \'lang_code\': \'de\',\n \'lemma\': \'Trittbrettfahrer\',\n \'pos\': {\'Substantiv\': []},\n \'syllables\': [\'Tritt\', \'brett\', \'fah\', \'rer\'],\n \'title\': \'Trittbrettfahrer\',\n \'wikitext\': \'=== {{Wortart|Substantiv|Deutsch}}, {{m}} ===\\n\'\n             \'\\n\'\n             \'{{Deutsch Substantiv Übersicht\\n\'\n             \'|Genus=m\\n\'\n             \'|Nominativ Singular=Trittbrettfahrer\\n\'\n             \'|Nominativ Plural=Trittbrettfahrer\\n\'\n             \'|Genitiv Singular=Trittbrettfahrers\\n\'\n             \'|Genitiv Plural=Trittbrettfahrer\\n\'\n             \'|Dativ Singular=Trittbrettfahrer\\n\'\n             \'|Dativ Plural=Trittbrettfahrern\\n\'\n             \'|Akkusativ Singular=Trittbrettfahrer\\n\'\n             \'|Akkusativ Plural=Trittbrettfahrer\\n\'\n             \'}}\\n\'\n             \'\\n\'\n             \'{{Worttrennung}}\\n\'\n             \':Tritt·brett·fah·rer, {{Pl.}} Tritt·brett·fah·rer\\n\'\n             \'\\n\'\n             \'{{Aussprache}}\\n\'\n             \':{{IPA}} {{Lautschrift|ˈtʁɪtbʁɛtˌfaːʁɐ}}\\n\'\n             \':{{Hörbeispiele}} {{Audio|}}\\n\'\n             \'\\n\'\n             \'{{Bedeutungen}}\\n\'\n             \':[1] Person, die ohne [[Anstrengung]] an Vorteilen teilhaben \'\n             \'will\\n\'\n             \'\\n\'\n             \'{{Herkunft}}\\n\'\n             \':[[Determinativkompositum]] aus den Substantiven \'\n             "\'\'[[Trittbrett]]\'\' und \'\'[[Fahrer]]\'\'\\n"\n             \'\\n\'\n             \'{{Weibliche Wortformen}}\\n\'\n             \':[1] [[Trittbrettfahrerin]]\\n\'\n             \'\\n\'\n             \'{{Beispiele}}\\n\'\n             \':[1] „Bleibt schließlich noch das Problem der \'\n             "\'\'Trittbrettfahrer,\'\' die sich ohne Versicherung aus "\n             \'Nachlässigkeit in das soziale Netz abgleiten \'\n             \'lassen.“<ref>{{Internetquelle|url=http://books.google.se/books?id=VjLq84xNpfMC&pg=PA446&dq=trittbrettfahrer&hl=de&sa=X&ei=8AztU4aVJYq_ygOd1oKIDA&ved=0CEEQ6AEwBjgK#v=onepage&q=trittbrettfahrer&f=false|titel=Öffentliche \'\n             \'Finanzen in der Demokratie: Eine Einführung, Charles B. \'\n             \'Blankart|zugriff=2014-08-14}}</ref>\\n\'\n             \'\\n\'\n             \'{{Wortbildungen}}\\n\'\n             \':[1] [[Trittbrettfahrer-Problem]]\\n\'\n             \'\\n\'\n             \'==== {{Übersetzungen}} ====\\n\'\n             \'{{Ü-Tabelle|Ü-links=\\n\'\n             \'*{{en}}: [1] {{Ü|en|free rider}}\\n\'\n             \'*{{fi}}: [1] {{Ü|fi|siipeilijä}}, {{Ü|fi|vapaamatkustaja}}\\n\'\n             \'*{{fr}}: [1] {{Ü|fr|profiteur}}\\n\'\n             \'|Ü-rechts=\\n\'\n             \'*{{it}}: [1] {{Ü|it|scroccone}} {{m}}\\n\'\n             \'*{{es}}: [1] {{Ü|es|}}\\n\'\n             \'}}\\n\'\n             \'\\n\'\n             \'{{Referenzen}}\\n\'\n             \':[1] {{Wikipedia|Trittbrettfahrer}}\\n\'\n             \':[*] {{Ref-DWDS|Trittbrettfahrer}}\\n\'\n             \':[*] {{Ref-Canoo|Trittbrettfahrer}}\\n\'\n             \':[1] {{Ref-UniLeipzig|Trittbrettfahrer}}\\n\'\n             \':[1] {{Ref-FreeDictionary|Trittbrettfahrer}}\\n\'\n             \'\\n\'\n             \'{{Quellen}}\'}\n```\n\n## License\n\n[MIT](https://github.com/gambolputty/wiktionary_de_parser/blob/master/LICENSE.md) © Gregor Weichbrodt\n',
    'author': 'Gregor Weichbrodt',
    'author_email': 'gregorweichbrodt@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/gambolputty/wiktionary_de_parser',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7,<4.0',
}


setup(**setup_kwargs)
