# mypy-boto3-ec2

[![PyPI - mypy-boto3-ec2](https://img.shields.io/pypi/v/mypy-boto3-ec2.svg?color=blue)](https://pypi.org/project/mypy-boto3-ec2)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ec2.svg?color=blue)](https://pypi.org/project/mypy-boto3-ec2)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.EC2 1.13.16](https://boto3.amazonaws.com/v1/documentation/api/1.13.16/reference/services/ec2.html#EC2) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.9](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-ec2](#mypy-boto3-ec2)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `EC2` service.

```bash
python -m pip install boto3-stubs[ec2]

# update installed packages index
mypy_boto3
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import ec2
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_ec2 as ec2

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("ec2")
client: ec2.EC2Client = boto3.client("ec2")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ec2.EC2Client = session.client("ec2")

# Do you prefer resource approach? We've got you covered!
resource: ec2.EC2ServiceResource = boto3.resource("ec2")

# Waiters need type annotation on creation
bundle_task_complete_waiter: ec2.BundleTaskCompleteWaiter = client.get_waiter("bundle_task_complete")
conversion_task_cancelled_waiter: ec2.ConversionTaskCancelledWaiter = client.get_waiter("conversion_task_cancelled")
conversion_task_completed_waiter: ec2.ConversionTaskCompletedWaiter = client.get_waiter("conversion_task_completed")
conversion_task_deleted_waiter: ec2.ConversionTaskDeletedWaiter = client.get_waiter("conversion_task_deleted")
customer_gateway_available_waiter: ec2.CustomerGatewayAvailableWaiter = client.get_waiter("customer_gateway_available")
export_task_cancelled_waiter: ec2.ExportTaskCancelledWaiter = client.get_waiter("export_task_cancelled")
export_task_completed_waiter: ec2.ExportTaskCompletedWaiter = client.get_waiter("export_task_completed")
image_available_waiter: ec2.ImageAvailableWaiter = client.get_waiter("image_available")
image_exists_waiter: ec2.ImageExistsWaiter = client.get_waiter("image_exists")
instance_exists_waiter: ec2.InstanceExistsWaiter = client.get_waiter("instance_exists")
instance_running_waiter: ec2.InstanceRunningWaiter = client.get_waiter("instance_running")
instance_status_ok_waiter: ec2.InstanceStatusOkWaiter = client.get_waiter("instance_status_ok")
instance_stopped_waiter: ec2.InstanceStoppedWaiter = client.get_waiter("instance_stopped")
instance_terminated_waiter: ec2.InstanceTerminatedWaiter = client.get_waiter("instance_terminated")
key_pair_exists_waiter: ec2.KeyPairExistsWaiter = client.get_waiter("key_pair_exists")
nat_gateway_available_waiter: ec2.NatGatewayAvailableWaiter = client.get_waiter("nat_gateway_available")
network_interface_available_waiter: ec2.NetworkInterfaceAvailableWaiter = client.get_waiter("network_interface_available")
password_data_available_waiter: ec2.PasswordDataAvailableWaiter = client.get_waiter("password_data_available")
security_group_exists_waiter: ec2.SecurityGroupExistsWaiter = client.get_waiter("security_group_exists")
snapshot_completed_waiter: ec2.SnapshotCompletedWaiter = client.get_waiter("snapshot_completed")
spot_instance_request_fulfilled_waiter: ec2.SpotInstanceRequestFulfilledWaiter = client.get_waiter("spot_instance_request_fulfilled")
subnet_available_waiter: ec2.SubnetAvailableWaiter = client.get_waiter("subnet_available")
system_status_ok_waiter: ec2.SystemStatusOkWaiter = client.get_waiter("system_status_ok")
volume_available_waiter: ec2.VolumeAvailableWaiter = client.get_waiter("volume_available")
volume_deleted_waiter: ec2.VolumeDeletedWaiter = client.get_waiter("volume_deleted")
volume_in_use_waiter: ec2.VolumeInUseWaiter = client.get_waiter("volume_in_use")
vpc_available_waiter: ec2.VpcAvailableWaiter = client.get_waiter("vpc_available")
vpc_exists_waiter: ec2.VpcExistsWaiter = client.get_waiter("vpc_exists")
vpc_peering_connection_deleted_waiter: ec2.VpcPeeringConnectionDeletedWaiter = client.get_waiter("vpc_peering_connection_deleted")
vpc_peering_connection_exists_waiter: ec2.VpcPeeringConnectionExistsWaiter = client.get_waiter("vpc_peering_connection_exists")
vpn_connection_available_waiter: ec2.VpnConnectionAvailableWaiter = client.get_waiter("vpn_connection_available")
vpn_connection_deleted_waiter: ec2.VpnConnectionDeletedWaiter = client.get_waiter("vpn_connection_deleted")

# Paginators need type annotation on creation
describe_byoip_cidrs_paginator: ec2.DescribeByoipCidrsPaginator = client.get_paginator("describe_byoip_cidrs")
describe_capacity_reservations_paginator: ec2.DescribeCapacityReservationsPaginator = client.get_paginator("describe_capacity_reservations")
describe_classic_link_instances_paginator: ec2.DescribeClassicLinkInstancesPaginator = client.get_paginator("describe_classic_link_instances")
describe_client_vpn_authorization_rules_paginator: ec2.DescribeClientVpnAuthorizationRulesPaginator = client.get_paginator("describe_client_vpn_authorization_rules")
describe_client_vpn_connections_paginator: ec2.DescribeClientVpnConnectionsPaginator = client.get_paginator("describe_client_vpn_connections")
describe_client_vpn_endpoints_paginator: ec2.DescribeClientVpnEndpointsPaginator = client.get_paginator("describe_client_vpn_endpoints")
describe_client_vpn_routes_paginator: ec2.DescribeClientVpnRoutesPaginator = client.get_paginator("describe_client_vpn_routes")
describe_client_vpn_target_networks_paginator: ec2.DescribeClientVpnTargetNetworksPaginator = client.get_paginator("describe_client_vpn_target_networks")
describe_coip_pools_paginator: ec2.DescribeCoipPoolsPaginator = client.get_paginator("describe_coip_pools")
describe_dhcp_options_paginator: ec2.DescribeDhcpOptionsPaginator = client.get_paginator("describe_dhcp_options")
describe_egress_only_internet_gateways_paginator: ec2.DescribeEgressOnlyInternetGatewaysPaginator = client.get_paginator("describe_egress_only_internet_gateways")
describe_export_image_tasks_paginator: ec2.DescribeExportImageTasksPaginator = client.get_paginator("describe_export_image_tasks")
describe_fast_snapshot_restores_paginator: ec2.DescribeFastSnapshotRestoresPaginator = client.get_paginator("describe_fast_snapshot_restores")
describe_fleets_paginator: ec2.DescribeFleetsPaginator = client.get_paginator("describe_fleets")
describe_flow_logs_paginator: ec2.DescribeFlowLogsPaginator = client.get_paginator("describe_flow_logs")
describe_fpga_images_paginator: ec2.DescribeFpgaImagesPaginator = client.get_paginator("describe_fpga_images")
describe_host_reservation_offerings_paginator: ec2.DescribeHostReservationOfferingsPaginator = client.get_paginator("describe_host_reservation_offerings")
describe_host_reservations_paginator: ec2.DescribeHostReservationsPaginator = client.get_paginator("describe_host_reservations")
describe_hosts_paginator: ec2.DescribeHostsPaginator = client.get_paginator("describe_hosts")
describe_iam_instance_profile_associations_paginator: ec2.DescribeIamInstanceProfileAssociationsPaginator = client.get_paginator("describe_iam_instance_profile_associations")
describe_import_image_tasks_paginator: ec2.DescribeImportImageTasksPaginator = client.get_paginator("describe_import_image_tasks")
describe_import_snapshot_tasks_paginator: ec2.DescribeImportSnapshotTasksPaginator = client.get_paginator("describe_import_snapshot_tasks")
describe_instance_credit_specifications_paginator: ec2.DescribeInstanceCreditSpecificationsPaginator = client.get_paginator("describe_instance_credit_specifications")
describe_instance_status_paginator: ec2.DescribeInstanceStatusPaginator = client.get_paginator("describe_instance_status")
describe_instance_type_offerings_paginator: ec2.DescribeInstanceTypeOfferingsPaginator = client.get_paginator("describe_instance_type_offerings")
describe_instance_types_paginator: ec2.DescribeInstanceTypesPaginator = client.get_paginator("describe_instance_types")
describe_instances_paginator: ec2.DescribeInstancesPaginator = client.get_paginator("describe_instances")
describe_internet_gateways_paginator: ec2.DescribeInternetGatewaysPaginator = client.get_paginator("describe_internet_gateways")
describe_ipv6_pools_paginator: ec2.DescribeIpv6PoolsPaginator = client.get_paginator("describe_ipv6_pools")
describe_launch_template_versions_paginator: ec2.DescribeLaunchTemplateVersionsPaginator = client.get_paginator("describe_launch_template_versions")
describe_launch_templates_paginator: ec2.DescribeLaunchTemplatesPaginator = client.get_paginator("describe_launch_templates")
describe_local_gateway_route_table_virtual_interface_group_associations_paginator: ec2.DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginator = client.get_paginator("describe_local_gateway_route_table_virtual_interface_group_associations")
describe_local_gateway_route_table_vpc_associations_paginator: ec2.DescribeLocalGatewayRouteTableVpcAssociationsPaginator = client.get_paginator("describe_local_gateway_route_table_vpc_associations")
describe_local_gateway_route_tables_paginator: ec2.DescribeLocalGatewayRouteTablesPaginator = client.get_paginator("describe_local_gateway_route_tables")
describe_local_gateway_virtual_interface_groups_paginator: ec2.DescribeLocalGatewayVirtualInterfaceGroupsPaginator = client.get_paginator("describe_local_gateway_virtual_interface_groups")
describe_local_gateway_virtual_interfaces_paginator: ec2.DescribeLocalGatewayVirtualInterfacesPaginator = client.get_paginator("describe_local_gateway_virtual_interfaces")
describe_local_gateways_paginator: ec2.DescribeLocalGatewaysPaginator = client.get_paginator("describe_local_gateways")
describe_moving_addresses_paginator: ec2.DescribeMovingAddressesPaginator = client.get_paginator("describe_moving_addresses")
describe_nat_gateways_paginator: ec2.DescribeNatGatewaysPaginator = client.get_paginator("describe_nat_gateways")
describe_network_acls_paginator: ec2.DescribeNetworkAclsPaginator = client.get_paginator("describe_network_acls")
describe_network_interface_permissions_paginator: ec2.DescribeNetworkInterfacePermissionsPaginator = client.get_paginator("describe_network_interface_permissions")
describe_network_interfaces_paginator: ec2.DescribeNetworkInterfacesPaginator = client.get_paginator("describe_network_interfaces")
describe_prefix_lists_paginator: ec2.DescribePrefixListsPaginator = client.get_paginator("describe_prefix_lists")
describe_principal_id_format_paginator: ec2.DescribePrincipalIdFormatPaginator = client.get_paginator("describe_principal_id_format")
describe_public_ipv4_pools_paginator: ec2.DescribePublicIpv4PoolsPaginator = client.get_paginator("describe_public_ipv4_pools")
describe_reserved_instances_modifications_paginator: ec2.DescribeReservedInstancesModificationsPaginator = client.get_paginator("describe_reserved_instances_modifications")
describe_reserved_instances_offerings_paginator: ec2.DescribeReservedInstancesOfferingsPaginator = client.get_paginator("describe_reserved_instances_offerings")
describe_route_tables_paginator: ec2.DescribeRouteTablesPaginator = client.get_paginator("describe_route_tables")
describe_scheduled_instance_availability_paginator: ec2.DescribeScheduledInstanceAvailabilityPaginator = client.get_paginator("describe_scheduled_instance_availability")
describe_scheduled_instances_paginator: ec2.DescribeScheduledInstancesPaginator = client.get_paginator("describe_scheduled_instances")
describe_security_groups_paginator: ec2.DescribeSecurityGroupsPaginator = client.get_paginator("describe_security_groups")
describe_snapshots_paginator: ec2.DescribeSnapshotsPaginator = client.get_paginator("describe_snapshots")
describe_spot_fleet_instances_paginator: ec2.DescribeSpotFleetInstancesPaginator = client.get_paginator("describe_spot_fleet_instances")
describe_spot_fleet_requests_paginator: ec2.DescribeSpotFleetRequestsPaginator = client.get_paginator("describe_spot_fleet_requests")
describe_spot_instance_requests_paginator: ec2.DescribeSpotInstanceRequestsPaginator = client.get_paginator("describe_spot_instance_requests")
describe_spot_price_history_paginator: ec2.DescribeSpotPriceHistoryPaginator = client.get_paginator("describe_spot_price_history")
describe_stale_security_groups_paginator: ec2.DescribeStaleSecurityGroupsPaginator = client.get_paginator("describe_stale_security_groups")
describe_subnets_paginator: ec2.DescribeSubnetsPaginator = client.get_paginator("describe_subnets")
describe_tags_paginator: ec2.DescribeTagsPaginator = client.get_paginator("describe_tags")
describe_traffic_mirror_filters_paginator: ec2.DescribeTrafficMirrorFiltersPaginator = client.get_paginator("describe_traffic_mirror_filters")
describe_traffic_mirror_sessions_paginator: ec2.DescribeTrafficMirrorSessionsPaginator = client.get_paginator("describe_traffic_mirror_sessions")
describe_traffic_mirror_targets_paginator: ec2.DescribeTrafficMirrorTargetsPaginator = client.get_paginator("describe_traffic_mirror_targets")
describe_transit_gateway_attachments_paginator: ec2.DescribeTransitGatewayAttachmentsPaginator = client.get_paginator("describe_transit_gateway_attachments")
describe_transit_gateway_multicast_domains_paginator: ec2.DescribeTransitGatewayMulticastDomainsPaginator = client.get_paginator("describe_transit_gateway_multicast_domains")
describe_transit_gateway_peering_attachments_paginator: ec2.DescribeTransitGatewayPeeringAttachmentsPaginator = client.get_paginator("describe_transit_gateway_peering_attachments")
describe_transit_gateway_route_tables_paginator: ec2.DescribeTransitGatewayRouteTablesPaginator = client.get_paginator("describe_transit_gateway_route_tables")
describe_transit_gateway_vpc_attachments_paginator: ec2.DescribeTransitGatewayVpcAttachmentsPaginator = client.get_paginator("describe_transit_gateway_vpc_attachments")
describe_transit_gateways_paginator: ec2.DescribeTransitGatewaysPaginator = client.get_paginator("describe_transit_gateways")
describe_volume_status_paginator: ec2.DescribeVolumeStatusPaginator = client.get_paginator("describe_volume_status")
describe_volumes_paginator: ec2.DescribeVolumesPaginator = client.get_paginator("describe_volumes")
describe_volumes_modifications_paginator: ec2.DescribeVolumesModificationsPaginator = client.get_paginator("describe_volumes_modifications")
describe_vpc_classic_link_dns_support_paginator: ec2.DescribeVpcClassicLinkDnsSupportPaginator = client.get_paginator("describe_vpc_classic_link_dns_support")
describe_vpc_endpoint_connection_notifications_paginator: ec2.DescribeVpcEndpointConnectionNotificationsPaginator = client.get_paginator("describe_vpc_endpoint_connection_notifications")
describe_vpc_endpoint_connections_paginator: ec2.DescribeVpcEndpointConnectionsPaginator = client.get_paginator("describe_vpc_endpoint_connections")
describe_vpc_endpoint_service_configurations_paginator: ec2.DescribeVpcEndpointServiceConfigurationsPaginator = client.get_paginator("describe_vpc_endpoint_service_configurations")
describe_vpc_endpoint_service_permissions_paginator: ec2.DescribeVpcEndpointServicePermissionsPaginator = client.get_paginator("describe_vpc_endpoint_service_permissions")
describe_vpc_endpoint_services_paginator: ec2.DescribeVpcEndpointServicesPaginator = client.get_paginator("describe_vpc_endpoint_services")
describe_vpc_endpoints_paginator: ec2.DescribeVpcEndpointsPaginator = client.get_paginator("describe_vpc_endpoints")
describe_vpc_peering_connections_paginator: ec2.DescribeVpcPeeringConnectionsPaginator = client.get_paginator("describe_vpc_peering_connections")
describe_vpcs_paginator: ec2.DescribeVpcsPaginator = client.get_paginator("describe_vpcs")
get_associated_ipv6_pool_cidrs_paginator: ec2.GetAssociatedIpv6PoolCidrsPaginator = client.get_paginator("get_associated_ipv6_pool_cidrs")
get_transit_gateway_attachment_propagations_paginator: ec2.GetTransitGatewayAttachmentPropagationsPaginator = client.get_paginator("get_transit_gateway_attachment_propagations")
get_transit_gateway_multicast_domain_associations_paginator: ec2.GetTransitGatewayMulticastDomainAssociationsPaginator = client.get_paginator("get_transit_gateway_multicast_domain_associations")
get_transit_gateway_route_table_associations_paginator: ec2.GetTransitGatewayRouteTableAssociationsPaginator = client.get_paginator("get_transit_gateway_route_table_associations")
get_transit_gateway_route_table_propagations_paginator: ec2.GetTransitGatewayRouteTablePropagationsPaginator = client.get_paginator("get_transit_gateway_route_table_propagations")
search_local_gateway_routes_paginator: ec2.SearchLocalGatewayRoutesPaginator = client.get_paginator("search_local_gateway_routes")
search_transit_gateway_multicast_groups_paginator: ec2.SearchTransitGatewayMulticastGroupsPaginator = client.get_paginator("search_transit_gateway_multicast_groups")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.