# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables


class Group(pulumi.CustomResource):
    create_time: pulumi.Output[str]
    """
    The time when the Group was created.
    """
    description: pulumi.Output[str]
    """
    An extended description to help users determine the purpose of a Group.
    Must not be longer than 4,096 characters.
    """
    display_name: pulumi.Output[str]
    """
    The display name of the Group.
    """
    group_key: pulumi.Output[dict]
    """
    EntityKey of the Group.  Structure is documented below.

      * `id` (`str`) - The ID of the entity.
        For Google-managed entities, the id must be the email address of an existing
        group or user.
        For external-identity-mapped entities, the id must be a string conforming
        to the Identity Source's requirements.
        Must be unique within a namespace.
      * `namespace` (`str`) - The namespace in which the entity exists.
        If not specified, the EntityKey represents a Google-managed entity
        such as a Google user or a Google Group.
        If specified, the EntityKey represents an external-identity-mapped group.
        The namespace must correspond to an identity source created in Admin Console
        and must be in the form of `identitysources/{identity_source_id}`.
    """
    labels: pulumi.Output[dict]
    """
    The labels that apply to the Group.
    Must not contain more than one entry. Must contain the entry
    'cloudidentity.googleapis.com/groups.discussion_forum': '' if the Group is a Google Group or
    'system/groups/external': '' if the Group is an external-identity-mapped group.
    """
    name: pulumi.Output[str]
    """
    Resource name of the Group in the format: groups/{group_id}, where group_id is the unique ID assigned to the Group.
    """
    parent: pulumi.Output[str]
    """
    The resource name of the entity under which this Group resides in the
    Cloud Identity resource hierarchy.
    Must be of the form identitysources/{identity_source_id} for external-identity-mapped
    groups or customers/{customer_id} for Google Groups.
    """
    update_time: pulumi.Output[str]
    """
    The time when the Group was last updated.
    """
    def __init__(__self__, resource_name, opts=None, description=None, display_name=None, group_key=None, labels=None, parent=None, __props__=None, __name__=None, __opts__=None):
        """
        Create a Group resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: An extended description to help users determine the purpose of a Group.
               Must not be longer than 4,096 characters.
        :param pulumi.Input[str] display_name: The display name of the Group.
        :param pulumi.Input[dict] group_key: EntityKey of the Group.  Structure is documented below.
        :param pulumi.Input[dict] labels: The labels that apply to the Group.
               Must not contain more than one entry. Must contain the entry
               'cloudidentity.googleapis.com/groups.discussion_forum': '' if the Group is a Google Group or
               'system/groups/external': '' if the Group is an external-identity-mapped group.
        :param pulumi.Input[str] parent: The resource name of the entity under which this Group resides in the
               Cloud Identity resource hierarchy.
               Must be of the form identitysources/{identity_source_id} for external-identity-mapped
               groups or customers/{customer_id} for Google Groups.

        The **group_key** object supports the following:

          * `id` (`pulumi.Input[str]`) - The ID of the entity.
            For Google-managed entities, the id must be the email address of an existing
            group or user.
            For external-identity-mapped entities, the id must be a string conforming
            to the Identity Source's requirements.
            Must be unique within a namespace.
          * `namespace` (`pulumi.Input[str]`) - The namespace in which the entity exists.
            If not specified, the EntityKey represents a Google-managed entity
            such as a Google user or a Google Group.
            If specified, the EntityKey represents an external-identity-mapped group.
            The namespace must correspond to an identity source created in Admin Console
            and must be in the form of `identitysources/{identity_source_id}`.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            __props__['display_name'] = display_name
            if group_key is None:
                raise TypeError("Missing required property 'group_key'")
            __props__['group_key'] = group_key
            if labels is None:
                raise TypeError("Missing required property 'labels'")
            __props__['labels'] = labels
            if parent is None:
                raise TypeError("Missing required property 'parent'")
            __props__['parent'] = parent
            __props__['create_time'] = None
            __props__['name'] = None
            __props__['update_time'] = None
        super(Group, __self__).__init__(
            'gcp:cloudidentity/group:Group',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, create_time=None, description=None, display_name=None, group_key=None, labels=None, name=None, parent=None, update_time=None):
        """
        Get an existing Group resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: The time when the Group was created.
        :param pulumi.Input[str] description: An extended description to help users determine the purpose of a Group.
               Must not be longer than 4,096 characters.
        :param pulumi.Input[str] display_name: The display name of the Group.
        :param pulumi.Input[dict] group_key: EntityKey of the Group.  Structure is documented below.
        :param pulumi.Input[dict] labels: The labels that apply to the Group.
               Must not contain more than one entry. Must contain the entry
               'cloudidentity.googleapis.com/groups.discussion_forum': '' if the Group is a Google Group or
               'system/groups/external': '' if the Group is an external-identity-mapped group.
        :param pulumi.Input[str] name: Resource name of the Group in the format: groups/{group_id}, where group_id is the unique ID assigned to the Group.
        :param pulumi.Input[str] parent: The resource name of the entity under which this Group resides in the
               Cloud Identity resource hierarchy.
               Must be of the form identitysources/{identity_source_id} for external-identity-mapped
               groups or customers/{customer_id} for Google Groups.
        :param pulumi.Input[str] update_time: The time when the Group was last updated.

        The **group_key** object supports the following:

          * `id` (`pulumi.Input[str]`) - The ID of the entity.
            For Google-managed entities, the id must be the email address of an existing
            group or user.
            For external-identity-mapped entities, the id must be a string conforming
            to the Identity Source's requirements.
            Must be unique within a namespace.
          * `namespace` (`pulumi.Input[str]`) - The namespace in which the entity exists.
            If not specified, the EntityKey represents a Google-managed entity
            such as a Google user or a Google Group.
            If specified, the EntityKey represents an external-identity-mapped group.
            The namespace must correspond to an identity source created in Admin Console
            and must be in the form of `identitysources/{identity_source_id}`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["create_time"] = create_time
        __props__["description"] = description
        __props__["display_name"] = display_name
        __props__["group_key"] = group_key
        __props__["labels"] = labels
        __props__["name"] = name
        __props__["parent"] = parent
        __props__["update_time"] = update_time
        return Group(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
