# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Union
from .. import utilities, tables


class CryptoKey(pulumi.CustomResource):
    key_ring: pulumi.Output[str]
    """
    The KeyRing that this key belongs to.
    Format: `'projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}'`.
    """
    labels: pulumi.Output[dict]
    """
    Labels with user-defined metadata to apply to this resource.
    """
    name: pulumi.Output[str]
    """
    The resource name for the CryptoKey.
    """
    purpose: pulumi.Output[str]
    """
    The immutable purpose of this CryptoKey. See the
    [purpose reference](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys#CryptoKeyPurpose)
    for possible inputs.
    """
    rotation_period: pulumi.Output[str]
    """
    Every time this period passes, generate a new CryptoKeyVersion and set it as the primary.
    The first rotation will take place after the specified period. The rotation period has
    the format of a decimal number with up to 9 fractional digits, followed by the
    letter `s` (seconds). It must be greater than a day (ie, 86400).
    """
    self_link: pulumi.Output[str]
    version_template: pulumi.Output[dict]
    """
    A template describing settings for new crypto key versions.  Structure is documented below.

      * `algorithm` (`str`) - The algorithm to use when creating a version based on this template.
        See the [algorithm reference](https://cloud.google.com/kms/docs/reference/rest/v1/CryptoKeyVersionAlgorithm) for possible inputs.
      * `protection_level` (`str`) - The protection level to use when creating a version based on this template.
    """
    def __init__(__self__, resource_name, opts=None, key_ring=None, labels=None, name=None, purpose=None, rotation_period=None, version_template=None, __props__=None, __name__=None, __opts__=None):
        """
        A `CryptoKey` represents a logical key that can be used for cryptographic operations.

        > **Note:** CryptoKeys cannot be deleted from Google Cloud Platform.
        Destroying a provider-managed CryptoKey will remove it from state
        and delete all CryptoKeyVersions, rendering the key unusable, but *will
        not delete the resource on the server.* When the provider destroys these keys,
        any data previously encrypted with these keys will be irrecoverable.
        For this reason, it is strongly recommended that you add lifecycle hooks
        to the resource to prevent accidental destruction.

        To get more information about CryptoKey, see:

        * [API documentation](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys)
        * How-to Guides
            * [Creating a key](https://cloud.google.com/kms/docs/creating-keys#create_a_key)

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] key_ring: The KeyRing that this key belongs to.
               Format: `'projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}'`.
        :param pulumi.Input[dict] labels: Labels with user-defined metadata to apply to this resource.
        :param pulumi.Input[str] name: The resource name for the CryptoKey.
        :param pulumi.Input[str] purpose: The immutable purpose of this CryptoKey. See the
               [purpose reference](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys#CryptoKeyPurpose)
               for possible inputs.
        :param pulumi.Input[str] rotation_period: Every time this period passes, generate a new CryptoKeyVersion and set it as the primary.
               The first rotation will take place after the specified period. The rotation period has
               the format of a decimal number with up to 9 fractional digits, followed by the
               letter `s` (seconds). It must be greater than a day (ie, 86400).
        :param pulumi.Input[dict] version_template: A template describing settings for new crypto key versions.  Structure is documented below.

        The **version_template** object supports the following:

          * `algorithm` (`pulumi.Input[str]`) - The algorithm to use when creating a version based on this template.
            See the [algorithm reference](https://cloud.google.com/kms/docs/reference/rest/v1/CryptoKeyVersionAlgorithm) for possible inputs.
          * `protection_level` (`pulumi.Input[str]`) - The protection level to use when creating a version based on this template.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if key_ring is None:
                raise TypeError("Missing required property 'key_ring'")
            __props__['key_ring'] = key_ring
            __props__['labels'] = labels
            __props__['name'] = name
            __props__['purpose'] = purpose
            __props__['rotation_period'] = rotation_period
            __props__['version_template'] = version_template
            __props__['self_link'] = None
        super(CryptoKey, __self__).__init__(
            'gcp:kms/cryptoKey:CryptoKey',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name, id, opts=None, key_ring=None, labels=None, name=None, purpose=None, rotation_period=None, self_link=None, version_template=None):
        """
        Get an existing CryptoKey resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param str id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] key_ring: The KeyRing that this key belongs to.
               Format: `'projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}'`.
        :param pulumi.Input[dict] labels: Labels with user-defined metadata to apply to this resource.
        :param pulumi.Input[str] name: The resource name for the CryptoKey.
        :param pulumi.Input[str] purpose: The immutable purpose of this CryptoKey. See the
               [purpose reference](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys#CryptoKeyPurpose)
               for possible inputs.
        :param pulumi.Input[str] rotation_period: Every time this period passes, generate a new CryptoKeyVersion and set it as the primary.
               The first rotation will take place after the specified period. The rotation period has
               the format of a decimal number with up to 9 fractional digits, followed by the
               letter `s` (seconds). It must be greater than a day (ie, 86400).
        :param pulumi.Input[dict] version_template: A template describing settings for new crypto key versions.  Structure is documented below.

        The **version_template** object supports the following:

          * `algorithm` (`pulumi.Input[str]`) - The algorithm to use when creating a version based on this template.
            See the [algorithm reference](https://cloud.google.com/kms/docs/reference/rest/v1/CryptoKeyVersionAlgorithm) for possible inputs.
          * `protection_level` (`pulumi.Input[str]`) - The protection level to use when creating a version based on this template.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["key_ring"] = key_ring
        __props__["labels"] = labels
        __props__["name"] = name
        __props__["purpose"] = purpose
        __props__["rotation_period"] = rotation_period
        __props__["self_link"] = self_link
        __props__["version_template"] = version_template
        return CryptoKey(resource_name, opts=opts, __props__=__props__)

    def translate_output_property(self, prop):
        return tables._CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return tables._SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop
