import os
from cameo_claw.cameo_claw_reuse import bytesio_to_gzip, requests_get_write, \
    bytesio_filename, write_gzip, read_csv_distinct
from cameo_claw.functional import it_mp_f
import polars as pl


def a_download(url, target_directory):
    def write(bytes1):
        filename = os.path.basename(url)
        path = f'{target_directory}{filename}'
        with open(path, 'wb') as f:
            f.write(bytes1)
        return url

    return requests_get_write(target_directory, url, write)


def it_download(lst_url, target_directory):
    return it_mp_f(a_download, [tuple([url, target_directory]) for url in lst_url])


def a_distinct(url, target_directory, lst_distinct_column):
    def write(bytes1):
        df = read_csv_distinct(bytes1, lst_distinct_column)
        return bytesio_to_gzip(df, url, target_directory)

    return requests_get_write(target_directory, url, write)


def it_distinct(lst_url, target_directory, lst_distinct_column):
    return it_mp_f(a_distinct, [tuple([url, target_directory, lst_distinct_column]) for url in lst_url])


def a_group(url, target_directory, lst_distinct_column, lst_group_by_column):
    def write(bytes1):
        df = read_csv_distinct(bytes1, lst_distinct_column)
        g = df.groupby(lst_group_by_column)
        for df in g:
            filename_tail = '_group_' + '-'.join(list(
                map(lambda column:
                    str(df.row(0)[df.find_idx_by_name(column)]).replace('_', '-'),
                    lst_group_by_column)))
            bytesio, filename = bytesio_filename(df, url)
            path = f'{target_directory}{filename}{filename_tail}.csv.gz'
            write_gzip(bytesio, path)
        return url

    return requests_get_write(target_directory, url, write)


def it_group(lst_url, target_directory, lst_distinct_column, lst_group_by_column):
    return it_mp_f(a_group,
                   [tuple([url, target_directory, lst_distinct_column, lst_group_by_column]) for url in lst_url])


def a_filter(url, target_directory, lst_distinct_column, lst_column_match=[], sort_column=''):
    def write(bytes1):
        df = read_csv_distinct(bytes1, lst_distinct_column)
        condition = ''
        for lst_col_val in lst_column_match:
            condition += f"""(pl.col('{lst_col_val[0]}')=='{lst_col_val[1]}') | """
        condition = condition[:-3]
        df = df.filter(eval(condition))
        if sort_column:
            df = df.sort(sort_column)
        bytesio_to_gzip(df, url, target_directory)
        return url

    return requests_get_write(target_directory, url, write)


def it_filter(lst_url, target_directory, lst_distinct_column, dic_column_match, sort_column):
    return it_mp_f(a_filter,
                   [tuple([url, target_directory, lst_distinct_column,
                           dic_column_match, sort_column]) for url in lst_url])
