"""Set of useful enums for input to Archery Australia classification routines."""

# To support python versions < 3.12 we can use the aenum library as a separate
# dependency before it was integrated into python3.11
# It is needed for iterable Flag in 3.11 and use of `in` for Flag in 3.12
import sys

if sys.version_info >= (3, 12):
    from enum import Enum, Flag, auto
else:  # pragma: no cover
    from aenum import Enum, Flag, auto


class AA_genders(Enum):
    """An enum for holding information about AA genders."""

    MALE = auto()
    FEMALE = auto()


class AA_ages(Flag):
    """An enum for holding information about AA ages."""

    AGE_70_PLUS = auto()
    AGE_60_PLUS = auto()
    AGE_50_PLUS = auto()
    AGE_ADULT = auto()
    AGE_UNDER_21 = auto()
    AGE_UNDER_18 = auto()
    AGE_UNDER_16 = auto()
    AGE_UNDER_14 = auto()


class AA_bowstyles(Flag):
    """
    An enum for holding information about AA bowstyles.

    Note that these do not consider some WA categories such as Traditional as these are
    not in the AA Rules of Shooting.
    """

    COMPOUND = auto()
    RECURVE = auto()
    BAREBOW = auto()
    BAREBOWCOMPOUND = auto()
    LONGBOW = auto()
