# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:26:54+00:00

from __future__ import annotations

import uuid
from enum import Enum

from pydantic import BaseModel, Extra, Field, constr


class Level(Enum):
    founder = 'founder'
    admin = 'admin'
    sales = 'sales'
    empty = 'empty'
    custom = 'custom'


class Access(BaseModel):
    pages: list[str] | None = None
    tabs: list[str] | None = None


class Acl(BaseModel):
    change_manufacturer: bool | None = None
    change_owner: bool | None = None
    share_object: bool | None = None


class Admin(BaseModel):
    handle_admin: bool | None = None


class Application(BaseModel):
    create_admin_application: bool | None = None
    delete_published: bool | None = None
    disable_and_reenable: bool | None = None
    handle_application_product: bool | None = None
    handle_publishing: bool | None = None
    retrieve_oauth_secrets: bool | None = None


class Billing(BaseModel):
    change_user_subscription: bool | None = None
    handle_subscription: bool | None = None
    handle_tax: bool | None = None
    show_stripe: bool | None = None


class Communication(BaseModel):
    create_translation: bool | None = None
    delete_translation: bool | None = None
    publish_translation: bool | None = None
    send_email: bool | None = None
    send_notification: bool | None = None
    send_sms: bool | None = None
    update_email: bool | None = None
    update_sms: bool | None = None
    update_translation: bool | None = None


class Customer(BaseModel):
    handle_customer: bool | None = None
    handle_seller: bool | None = None
    list_customer: bool | None = None
    list_seller: bool | None = None


class Couchbase(BaseModel):
    access_user_bucket: bool | None = None
    delete: bool | None = None
    retrieve: bool | None = None
    save: bool | None = None
    retrieve_meta: bool | None = None


class Documentation(BaseModel):
    access_admin_documentation: bool | None = None


class Installation(BaseModel):
    restart_with_new_process: bool | None = None
    restart_with_new_user: bool | None = None
    retrieve_oauth_secret_token: bool | None = None
    stop_background: bool | None = None
    log_background: bool | None = None


class Meta(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class Micro(BaseModel):
    read_environment: bool | None = None
    retrieve_micro: bool | None = None
    show_environment: bool | None = None
    show_grafana: bool | None = None
    update_environment: bool | None = None


class Network(BaseModel):
    contact_directly: bool | None = None
    update_creator: bool | None = None
    handle_firmware: bool | None = None


class Recovery(BaseModel):
    recover_background: bool | None = None
    recover_cleanup: bool | None = None
    recover_repeat: bool | None = None


class Services(BaseModel):
    cockroach: bool | None = None
    full_search: bool | None = None
    n1ql: bool | None = None
    nats: bool | None = None


class Session(BaseModel):
    write_permission: bool | None = None


class Support(BaseModel):
    delete_historical: bool | None = None
    handle_cleanup_historical: bool | None = None
    handle_delayed_state: bool | None = None
    handle_pending: bool | None = None


class Transfer(BaseModel):
    promote_application: bool | None = None
    promote_email_and_sms: bool | None = None
    promote_subscription: bool | None = None
    promote_translation: bool | None = None
    transfer_user: bool | None = None


class Uiadmin(BaseModel):
    show_create_object_button: bool | None = None
    show_delete_object_button: bool | None = None
    show_update_object_button: bool | None = None


class User(BaseModel):
    ban_user: bool | None = None
    change_password: bool | None = None
    change_username: bool | None = None
    create_new_user: bool | None = None
    delete_user: bool | None = None
    reset_captcha: bool | None = None
    verify_communication: bool | None = None


class Wallet(BaseModel):
    change_points: bool | None = None
    correct_points: bool | None = None
    reset_points: bool | None = None


class AdminFeature(BaseModel):
    class Config:
        extra = Extra.allow

    level:  Level | None = None
    access:  Access | None = None
    acl:  Acl | None = None
    admin:  Admin | None = None
    application:  Application | None = None
    billing:  Billing | None = None
    communication:  Communication | None = None
    customer:  Customer | None = None
    couchbase:  Couchbase | None = None
    documentation:  Documentation | None = None
    installation:  Installation | None = None
    meta: Meta | None = Field(None, title='meta-2.1')
    micro:  Micro | None = None
    network: Network | None = None
    recovery:  Recovery | None = None
    services:  Services | None = None
    session:  Session | None = None
    support:  Support | None = None
    transfer:  Transfer | None = None
    uiadmin:  Uiadmin | None = None
    user:  User | None = None
    wallet:  Wallet | None = None
