# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:32:06+00:00

from __future__ import annotations

import uuid
from typing import Any
from pydantic import BaseModel, Extra, Field, constr


class Restart(BaseModel):
    class Config:
        extra = Extra.forbid

    new_process: bool | None = None
    new_user: bool | None = None
    stop_background: bool | None = None


class Meta(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class OauthItem(BaseModel):
    class Config:
        extra = Extra.forbid

    client_id: uuid.UUID | None = None
    name: str | None = None
    expires: bool | None = None
    expired: bool | None = None
    active: bool | None = None
    installation_id: uuid.UUID | None = None
    meta: Meta | None = Field(None, title='meta-2.1')


class OauthConnectItem(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str | None = None
    api: uuid.UUID | None = None
    installation: uuid.UUID | None = None
    token: str | None = None
    secret_token: str | None = None
    params: dict[str, Any] | None = None
    meta: Meta | None = Field(None, title='meta-2.1')
    access_token_creation: dict[str, Any] | None = None


class Installation(BaseModel):
    class Config:
        extra = Extra.allow

    application: uuid.UUID
    title: str | None = None
    upgrade: bool | None = None
    ignore_this_notification: str | None = None
    extsync: bool | None = None
    permit_to_send_email: bool | None = None
    permit_to_send_sms: bool | None = None
    no_start_background: bool | None = None
    restart:  Restart | None = None
    application_product: uuid.UUID | None = None
    meta: Meta | None = Field(None, title='meta-2.1')
    oauth: list[OauthItem | uuid.UUID] | None = None
    oauth_connect: list[OauthConnectItem | uuid.UUID] | None = None
