# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:32:22+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum

from pydantic import BaseModel, Extra, Field, conint, constr


class Meta(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class Interval(Enum):
    second = 'second'
    minute = 'minute'
    hour = 'hour'
    day = 'day'
    week = 'week'
    month = 'month'
    year = 'year'


class Recurring(BaseModel):
    class Config:
        extra = Extra.forbid

    interval: Interval
    interval_count: conint(ge=1)


class Mda(BaseModel):
    class Config:
        extra = Extra.allow

    meta: Meta | None = Field(None, title='meta-2.1')
    quantity: int | None = None
    limit: int | None = None
    period_quantity: int | None = None
    recurring: Recurring | None = None
    start_period: datetime.datetime | None = None
    end_period: datetime.datetime | None = None
