# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:33:38+00:00

from __future__ import annotations

import uuid
from enum import Enum
from typing import Any

from pydantic import BaseModel, Extra, Field, constr


class AccessTokenMethod(Enum):
    get = 'get'
    post = 'post'


class OauthVersion(Enum):
    field_1_0 = '1.0'
    field_1_0a = '1.0a'
    field_2_0 = '2.0'


class RefreshAccessTokenMethod(Enum):
    get = 'get'
    post = 'post'


class Meta(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class OauthExternal(BaseModel):
    class Config:
        extra = Extra.allow

    name: str
    description: str | None = None
    api_callback: str | None = None
    api_key: str
    api_secret_key: str
    api_site: str
    api_extra_request: dict[str, Any] | None = None
    api_extra_request_required: list[str] | None = None
    api_extra_access_token: dict[str, Any] | None = None
    access_token_method:  AccessTokenMethod | None = None
    application_id: uuid.UUID | None = None
    oauth_version: OauthVersion
    oauth_request_token_url: str | None = None
    oauth_access_token_url: str | None = None
    oauth_refresh_access_token_url: str | None = None
    api_extra_refresh_access_token: dict[str, Any] | None = None
    refresh_access_token_method:  RefreshAccessTokenMethod | None = None
    meta: Meta | None = Field(None, title='meta-2.1')
