# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:34:04+00:00

from __future__ import annotations

import uuid
from enum import Enum
from typing import Any

from pydantic import BaseModel, Extra, Field, constr


class FromItem(BaseModel):
    class Config:
        extra = Extra.forbid

    type: str
    filter: list | None = None
    automatically_accept: bool | None = None


class Application(BaseModel):
    class Config:
        extra = Extra.forbid

    sharing: bool | None = None
    permitted: list[uuid.UUID] | None = None


class Method(BaseModel):
    create: bool | None = None
    update: bool | None = None
    retrieve: bool | None = None
    delete: bool | None = None


class State(BaseModel):
    class Config:
        extra = Extra.forbid

    min_state: float | None = None
    max_state: float | None = None


class Installation(BaseModel):
    class Config:
        extra = Extra.forbid

    shareable: bool | None = None


class File(BaseModel):
    background: bool | None = None


class AclAttribute(Enum):
    parent_name = 'parent_name'


class Restriction(BaseModel):
    class Config:
        extra = Extra.forbid

    child: str | None = None
    create: list[str] | None = None
    application:  Application | None = None
    method:  Method | None = None
    time: dict[str, Any] | None = None
    state:  State | None = None
    installation:  Installation | None = None
    file:  File | None = None
    acl_attributes: list[AclAttribute] | None = None


class ToItem(BaseModel):
    class Config:
        extra = Extra.forbid

    type: str
    filter: list | None = None
    restriction:  Restriction | None = None


class Meta(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class PermissionRule(BaseModel):
    class Config:
        extra = Extra.forbid

    apply_to_old: bool | None = None
    from_: list[FromItem] | None = Field(None, alias='from')
    to: list[ToItem] | None = None
    meta: Meta | None = Field(None, title='meta-2.1')
