# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:34:47+00:00

from __future__ import annotations

import uuid
from typing import Any
from pydantic import BaseModel, Extra, Field, constr


class DriverItem(BaseModel):
    class Config:
        extra = Extra.forbid

    type: str
    config: dict[str, Any] | None = None
    mapping: dict[str, Any]


class Meta(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class Prototype(BaseModel):
    class Config:
        extra = Extra.allow

    creator_id: uuid.UUID | None = None
    model_id: uuid.UUID | None = None
    prototype_id: uuid.UUID | None = None
    name: str | None = None
    model: dict[str, Any] | None = None
    driver: list[DriverItem] | None = None
    target: str | None = None
    deploy: bool | None = None
    built: bool | None = None
    meta: Meta | None = Field(None, title='meta-2.1')
