# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:35:34+00:00

from __future__ import annotations

import uuid
from enum import Enum
from typing import Any

from pydantic import BaseModel, Extra, Field, conint, constr


class Operation(Enum):
    async_ = 'async'
    sync = 'sync'
    intersect = 'intersect'


class Method(Enum):
    POST = 'POST'
    GET = 'GET'
    DELETE = 'DELETE'
    PUT = 'PUT'
    HEAD = 'HEAD'
    PATCH = 'PATCH'


class InputItem(BaseModel):
    class Config:
        extra = Extra.forbid

    method: Method
    url: str
    query: list[str] | None = None
    body: Any | None = None


class Action(Enum):
    stop = 'stop'
    restart = 'restart'


class Meta(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class Repeat(BaseModel):
    class Config:
        extra = Extra.allow

    name: str | None = None
    interval: conint(ge=0) | None = None
    operation:  Operation | None = None
    input: list[InputItem]
    action: Action | None = None
    meta: Meta | None = Field(None, title='meta-2.1')
