# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:27:18+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Any

from pydantic import BaseModel, Extra, Field, conint, constr


class Meta(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class Engine(Enum):
    node = 'node'
    python = 'python'


class Executable(BaseModel):
    class Config:
        extra = Extra.forbid

    engine: Engine | None = None
    version: str | None = None


class SupportedFeature(Enum):
    foreground = 'foreground'
    background = 'background'
    widget = 'widget'


class Description(BaseModel):
    class Config:
        extra = Extra.forbid

    general: str | None = None
    foreground: str | None = None
    background: str | None = None
    widget: str | None = None
    version: str | None = None


class Status(Enum):
    idle = 'idle'
    commit = 'commit'
    revision = 'revision'
    publish = 'publish'
    uncommit = 'uncommit'
    unpublish = 'unpublish'
    republish = 'republish'
    disable = 'disable'
    reenable = 'reenable'
    duplicate = 'duplicate'
    pending = 'pending'
    uncommitted = 'uncommitted'
    published = 'published'
    not_updated = 'not updated'
    unpublished = 'unpublished'
    disabled = 'disabled'


class Permission(BaseModel):
    create: list[str] | None = None
    permit_to_send_email: bool | None = None
    permit_to_send_sms: bool | None = None


class ConcernItem(BaseModel):
    class Config:
        extra = Extra.forbid

    concern: str
    line: conint(ge=0, multiple_of=1)


class ConcernFileItem(BaseModel):
    class Config:
        extra = Extra.forbid

    timestamp: datetime.datetime
    concern: list[ConcernItem] = Field(..., min_items=1)


class FileItem(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str | None = None
    type: str | None = None
    size: conint(ge=0, multiple_of=1) | None = None
    concernFile: list[ConcernFileItem] | None = None
    meta: Meta | None = Field(None, title='meta-2.1')


class VersionItem(BaseModel):
    class Config:
        extra = Extra.allow

    name: str
    name_identifier: constr(regex=r'[0-9a-z_]') | None = None
    author: str | None = None
    version_app: constr(regex=r'^(\d+\.\d+\.\d+)$') | None = None
    commit: str | None = None
    date: datetime.datetime | None = None
    title: str | None = None
    session_user: bool | None = None
    concern: str | None = None
    native: bool | None = None
    name_folder: str | None = None
    icon: uuid.UUID | None = None
    version_to_clone: uuid.UUID | None = None
    uninstallable: bool | None = None
    executable: Executable | None = None
    max_number_installation: conint(ge=1) | None = None
    object_requested: dict[str, Any] | None = None
    supported_features: list[SupportedFeature] | None = None
    description: Description | None = None
    status: Status | None = None
    used_files: dict[str, Any] | None = None
    meta: Meta | None = Field(None, title='meta-2.1')
    permission: Permission | None = None
    file: list[FileItem | uuid.UUID] | None = None


class ExternalItem(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str
    api_key: str
    api_secret_key: str
    api_site: str


class OauthClientItem(BaseModel):
    class Config:
        extra = Extra.allow

    name: str
    company: str | None = None
    description: str | None = None
    homepage_url: str | None = None
    expires: conint(ge=0) | None = None
    client_id: uuid.UUID | None = None
    client_secret: str | None = None
    redirect_uri: list[str]
    path_access_token: list[str] | None = None
    meta: Meta | None = Field(None, title='meta-2.1')
    external: list[ExternalItem] | None = None


class AccessTokenMethod(Enum):
    get = 'get'
    post = 'post'


class OauthVersion(Enum):
    field_1_0 = '1.0'
    field_1_0a = '1.0a'
    field_2_0 = '2.0'


class RefreshAccessTokenMethod(Enum):
    get = 'get'
    post = 'post'


class OauthExternalItem(BaseModel):
    class Config:
        extra = Extra.allow

    name: str
    description: str | None = None
    api_callback: str | None = None
    api_key: str
    api_secret_key: str
    api_site: str
    api_extra_request: dict[str, Any] | None = None
    api_extra_request_required: list[str] | None = None
    api_extra_access_token: dict[str, Any] | None = None
    access_token_method:  AccessTokenMethod | None = None
    application_id: uuid.UUID | None = None
    oauth_version: OauthVersion
    oauth_request_token_url: str | None = None
    oauth_access_token_url: str | None = None
    oauth_refresh_access_token_url: str | None = None
    api_extra_refresh_access_token: dict[str, Any] | None = None
    refresh_access_token_method:  RefreshAccessTokenMethod | None = None
    meta: Meta | None = Field(None, title='meta-2.1')


class Type(Enum):
    one_time = 'one_time'
    subscription = 'subscription'


class Interval(Enum):
    day = 'day'
    week = 'week'
    month = 'month'
    year = 'year'


class Recurring(BaseModel):
    class Config:
        extra = Extra.forbid

    interval: Interval
    interval_count: conint(ge=1)


class Tax(BaseModel):
    id: uuid.UUID | None = None


class ApplicationProductItem(BaseModel):
    class Config:
        extra = Extra.allow

    meta: Meta | None = Field(None, title='meta-2.1')
    name: str
    description: str | None = None
    active: bool | None = None
    type: Type
    currency: str
    amount: conint(ge=1)
    recurring: Recurring | None = None
    tax: Tax | None = None
    trial_period_days: conint(ge=1) | None = None


class Application(BaseModel):
    class Config:
        extra = Extra.allow

    name: str | None = None
    name_identifier: constr(regex=r'[0-9a-z_]') | None = None
    meta: Meta | None = Field(None, title='meta-2.1')
    permit_free: bool | None = None
    version: list[VersionItem | uuid.UUID] | None = None
    oauth_client: list[OauthClientItem | uuid.UUID] | None = Field(None, max_items=1)
    oauth_external: list[OauthExternalItem | uuid.UUID] | None = None
    application_product: list[ApplicationProductItem | uuid.UUID] | None = None
