# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:27:24+00:00

from __future__ import annotations

import uuid
from enum import Enum

from pydantic import BaseModel, Extra, Field, conint, constr


class Meta(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class Type(Enum):
    one_time = 'one_time'
    subscription = 'subscription'


class Interval(Enum):
    day = 'day'
    week = 'week'
    month = 'month'
    year = 'year'


class Recurring(BaseModel):
    class Config:
        extra = Extra.forbid

    interval: Interval
    interval_count: conint(ge=1)


class Tax(BaseModel):
    id: uuid.UUID | None = None


class ApplicationProduct(BaseModel):
    class Config:
        extra = Extra.allow

    meta: Meta | None = Field(None, title='meta-2.1')
    name: str
    description: str | None = None
    active: bool | None = None
    type: Type
    currency: str
    amount: conint(ge=1)
    recurring: Recurring | None = None
    tax: Tax | None = None
    trial_period_days: conint(ge=1) | None = None
