# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:28:50+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Any

from pydantic import BaseModel, Extra, Field, confloat, constr


class Meta(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class Recurrency(Enum):
    month = 'month'
    quarter = 'quarter'
    year = 'year'


class Language(Enum):
    en = 'en'
    dk = 'dk'


class Information(BaseModel):
    company: str | None = None
    street: str | None = None
    post_number: str | None = None
    city: str | None = None
    country: str | None = None
    tax_code: str | None = None
    tax_code_type: str | None = None
    email: str | None = None
    phone: str | None = None


class TheirReference(BaseModel):
    name: str | None = None
    email: str | None = None
    phone: str | None = None


class OurReference(BaseModel):
    name: str | None = None
    email: str | None = None
    phone: str | None = None


class Recurrency1(Enum):
    one_time = 'one_time'
    subscription = 'subscription'


class Type(Enum):
    network = 'network'
    installation = 'installation'
    application = 'application'
    creator = 'creator'
    generic = 'generic'


class InvoiceItem(BaseModel):
    class Config:
        extra = Extra.allow

    recurrency:  Recurrency1 | None = None
    type: Type
    filter: str | None = None
    filter_by_name: str | None = None
    filter_by_application: uuid.UUID | None = None
    quantity: int | None = None
    cost: int
    description: str
    dynamic: bool | None = None
    unit: str | None = None


class CustomerInvoiceItem(BaseModel):
    class Config:
        extra = Extra.allow

    meta: Meta | None = Field(None, title='meta-2.1')
    name: str | None = None
    description: str | None = None
    paid: bool | None = None
    sent: bool | None = None
    currency: str | None = None
    archived: bool | None = None
    due_days_after_sending_invoice: int | None = None
    due_timestamp: datetime.datetime | None = None
    paid_timestamp: datetime.datetime | None = None
    sent_timestamp: datetime.datetime | None = None
    due_payment_timestamp: datetime.datetime | None = None
    discount: confloat(ge=0.0, le=100.0) | None = None
    discount_before_tax: bool | None = None
    create_automatic_next_invoice: bool | None = None
    tax: confloat(ge=0.0, le=100.0) | None = None
    tax_included: bool | None = None
    note: list[str] | None = None
    invoice: list[InvoiceItem] | None = None


class Customer(BaseModel):
    class Config:
        extra = Extra.allow

    meta: Meta | None = Field(None, title='meta-2.1')
    user_id: str
    seller: uuid.UUID | None = None
    currency: str | None = None
    due_days_after_sending_invoice: int | None = None
    discount_before_tax: bool | None = None
    tax_included: bool | None = None
    note: list[str] | None = None
    next_invoice: dict[str, Any] | None = None
    last_invoice: dict[str, Any] | None = None
    recurrency:  Recurrency | None = None
    create_automatic_next_invoice: bool | None = None
    archived: bool | None = None
    language:  Language | None = None
    information:  Information | None = None
    their_reference:  TheirReference | None = None
    our_reference:  OurReference | None = None
    customer_invoice: list[CustomerInvoiceItem | uuid.UUID] | None = None
