# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:28:56+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum

from pydantic import BaseModel, Extra, Field, confloat, constr


class Meta(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class Recurrency(Enum):
    one_time = 'one_time'
    subscription = 'subscription'


class Type(Enum):
    network = 'network'
    installation = 'installation'
    application = 'application'
    creator = 'creator'
    generic = 'generic'


class InvoiceItem(BaseModel):
    class Config:
        extra = Extra.allow

    recurrency:  Recurrency | None = None
    type: Type
    filter: str | None = None
    filter_by_name: str | None = None
    filter_by_application: uuid.UUID | None = None
    quantity: int | None = None
    cost: int
    description: str
    dynamic: bool | None = None
    unit: str | None = None


class CustomerInvoice(BaseModel):
    class Config:
        extra = Extra.allow

    meta: Meta | None = Field(None, title='meta-2.1')
    name: str | None = None
    description: str | None = None
    paid: bool | None = None
    sent: bool | None = None
    currency: str | None = None
    archived: bool | None = None
    due_days_after_sending_invoice: int | None = None
    due_timestamp: datetime.datetime | None = None
    paid_timestamp: datetime.datetime | None = None
    sent_timestamp: datetime.datetime | None = None
    due_payment_timestamp: datetime.datetime | None = None
    discount: confloat(ge=0.0, le=100.0) | None = None
    discount_before_tax: bool | None = None
    create_automatic_next_invoice: bool | None = None
    tax: confloat(ge=0.0, le=100.0) | None = None
    tax_included: bool | None = None
    note: list[str] | None = None
    invoice: list[InvoiceItem] | None = None
