# generated by datamodel-codegen:
#   filename:  schema.json
#   timestamp: 2021-07-08T11:31:02+00:00

# from __future__ import annotations

from datetime import datetime
from enum import Enum

from typing import Any

from pydantic import BaseModel
from pydantic import conint
from pydantic import constr
from pydantic import Extra
from pydantic import Field
from pydantic import root_validator
from pydantic import UUID4

from ...core.utils import timestamp
from ..base import WappstoVersion


class InclusionStatus(str, Enum):
    STATUS_DEVICE_INCLUDING = 'STATUS_DEVICE_INCLUDING'
    STATUS_DEVICE_INCLUSION_SUCCESS = 'STATUS_DEVICE_INCLUSION_SUCCESS'
    STATUS_DEVICE_INCLUSION_FAILURE = 'STATUS_DEVICE_INCLUSION_FAILURE'
    STATUS_DEVICE_REPORTING = 'STATUS_DEVICE_REPORTING'
    STATUS_DEVICE_REPORT_SUCCESS = 'STATUS_DEVICE_REPORT_SUCCESS'
    STATUS_DEVICE_REPORT_FAILURE = 'STATUS_DEVICE_REPORT_FAILURE'
    EXCLUDED = 'EXCLUDED'
    INCLUDED = 'INCLUDED'


class FirmwareStatus(str, Enum):
    UP_TO_DATE = 'UP_TO_DATE'
    UPDATE_AVAILABLE = 'UPDATE_AVAILABLE'
    UPLOADING = 'UPLOADING'
    UPLOAD_COMPLETE = 'UPLOAD_COMPLETE'
    UPLOADING_FAILURE = 'UPLOADING_FAILURE'
    FLASHING = 'FLASHING'
    FLASHING_COMPLETE = 'FLASHING_COMPLETE'
    FLASHING_FAILURE = 'FLASHING_FAILURE'


class Command(str, Enum):
    IDLE = 'idle'
    FIRMWARE_UPLOAD = 'firmware_upload'
    FIRMWARE_FLASH = 'firmware_flash'
    FIRMWARE_CANCEL = 'firmware_cancel'
    INCLUDE = 'include'
    EXCLUDE = 'exclude'
    CONNECTION_CHECK = 'connection_check'


class OwnerEnum(str, Enum):
    UNASSIGNED = 'unassigned'


class Deletion(str, Enum):
    PENDING = 'pending'
    FAILED = 'failed'


class PermissionType(str, Enum):
    """All possible Value Permission Types."""
    READ = 'r'
    WRITE = 'w'
    READWRITE = 'rw'
    WRITEREAD = 'wr'
    NONE = 'none'


class EventStatus(str, Enum):
    OK = 'ok'
    UPDATE = 'update'
    PENDING = 'pending'


class StateType(str, Enum):
    REPORT = 'Report'
    CONTROL = 'Control'


class StateStatus(str, Enum):
    SEND = 'Send'
    PENDING = 'Pending'
    FAILED = 'Failed'


class Level(str, Enum):
    IMPORTANT = 'important'
    ERROR = 'error'
    WARNING = 'warning'
    SUCCESS = 'success'
    INFO = 'info'
    DEBUG = 'debug'


class StatusType(str, Enum):
    PUBLIC_KEY = 'public key'
    MEMORY_INFORMATION = 'memory information'
    DEVICE_DESCRIPTION = 'device description'
    VALUE_DESCRIPTION = 'value description'
    VALUE = 'value'
    PARTNER_INFORMATION = 'partner information'
    ACTION = 'action'
    CALCULATION = 'calculation'
    TIMER = 'timer'
    CALENDAR = 'calendar'
    STATEMACHINE = 'statemachine'
    FIRMWARE_UPDATE = 'firmware update'
    CONFIGURATION = 'configuration'
    EXI = 'exi'
    SYSTEM = 'system'
    APPLICATION = 'application'
    GATEWAY = 'gateway'


class WappstoMetaType(str, Enum):
    """
    All possible Wappsto Meta Types.

    They have a parent child relation in order of:
    network->device->value->state

    Where a 'Network' only contains 'Device's,
    'Device's only contains 'value's, and
    'Value's only contains 'State's.
    """
    NETWORK = "network"
    DEVICE = "device"
    VALUE = "value"
    STATE = "state"
    CREATOR = "creator"
    IDLIST = "idlist"
    DELETELIST = "deletelist"


class Connection(BaseModel):
    timestamp: datetime | None = None
    online: bool | None = None

    class Config:
        json_encoders = {
            datetime: timestamp
        }


class WarningItem(BaseModel):
    message: str | None = None
    data: dict[str, Any] | None = None
    code: int | None = None


class Geo(BaseModel):
    latitude: str | None = None
    longitude: str | None = None
    display_name: str | None = None
    address: dict[str, Any] | None = None


class BaseMeta(BaseModel):  # Base Meta
    id: UUID4 | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    historical: bool | None = None

    class Config:
        json_encoders = {
            datetime: timestamp
        }


class EventlogMeta(BaseMeta):
    class WappstoMetaType(str, Enum):
        STATUS = "eventlog"
    type: WappstoMetaType | None = None

    icon: str | None = None
    alert: list[UUID4] | None = None


class StatusMeta(BaseMeta):
    class WappstoMetaType(str, Enum):
        STATUS = "status"
    type: WappstoMetaType | None = None

    icon: str | None = None
    alert: list[UUID4] | None = None


class ValueMeta(BaseMeta):
    class WappstoMetaType(str, Enum):
        VALUE = "value"
    type: WappstoMetaType | None = None


class StateMeta(BaseMeta):
    class WappstoMetaType(str, Enum):
        STATE = "state"
    type: WappstoMetaType | None = None


class DeviceMeta(BaseMeta):
    class WappstoMetaType(str, Enum):
        DEVICE = "device"
    type: WappstoMetaType | None = None

    geo: Geo | None = None


class NetworkMeta(BaseMeta):
    class WappstoMetaType(str, Enum):
        NETWORK = "network"
    type: WappstoMetaType | None = None

    geo: Geo | None = None
    connection: Connection | None = None
    accept_test_mode: bool | None = None
    verify_product: str | None = None
    product: str | None = None


class Status(BaseModel):
    message: str
    timestamp: datetime
    data: str | None = None
    level: Level
    type: StatusType | None
    meta: StatusMeta | None = Field(None, title='meta-2.0:create')

    class Config:
        json_encoders = {
            datetime: timestamp
        }


class Info(BaseModel):
    enabled: bool | None = None


class State(BaseModel):
    data: str
    type: StateType | None

    meta: StateMeta | None = Field(None, title='meta-2.0:create')
    status: StateStatus | None = None
    status_payment: str | None = None
    timestamp: datetime | None = None

    class Config:
        extra = Extra.forbid
        json_encoders = {
            datetime: timestamp,
        }


class EventlogItem(BaseModel):
    message: str
    timestamp: datetime | None = None
    info: dict[str, Any] | None = None
    level: Level
    type: str | None = None
    meta: EventlogMeta | None = Field(None, title='meta-2.0:create')


class BaseValue(BaseModel):
    name: str | None = None
    type: str | None = None
    description: str | None = None
    period: str | None = None
    delta: str | None = None
    permission: PermissionType | None = None
    status: EventStatus | None = None
    meta: ValueMeta | None = Field(None, title='meta-2.0:create')
    state: list[State | UUID4] | None = None
    eventlog: list[EventlogItem | UUID4] | None = None
    info: Info | None = None


class Number(BaseModel):
    min: float
    max: float
    step: float
    mapping: dict[str, Any] | None = None
    meaningful_zero: bool | None = None
    ordered_mapping: bool | None = None
    si_conversion: str | None = None
    unit: str | None = None


class String(BaseModel):
    max: conint(ge=1, multiple_of=1) | None = None  # type: ignore
    encoding: str | None = None


class Blob(BaseModel):
    max: conint(ge=1, multiple_of=1) | None = None  # type: ignore
    encoding: str | None = None


class Xml(BaseModel):
    xsd: str | None = None
    namespace: str | None = None


class StringValue(BaseValue):
    string: String | None = None

    @root_validator(pre=True)
    def value_type_check(cls, values):
        keys = ["number", "blob", "xml"]
        if any(key in values for key in keys):
            raise TypeError(f"A string value can not contain: {' '.join(keys)}")
        return values


class NumberValue(BaseValue):
    number: Number | None = None

    @root_validator(pre=True)
    def value_type_check(cls, values):
        keys = ["string", "blob", "xml"]
        if any(key in values for key in keys):
            raise TypeError(f"A number value can not contain: {' '.join(keys)}")
        return values


class BlobValue(BaseValue):
    blob: Blob | None = None

    @root_validator(pre=True)
    def value_type_check(cls, values):
        keys = ["number", "string", "xml"]
        if any(key in values for key in keys):
            raise TypeError(f"A blob value can not contain: {' '.join(keys)}")
        return values


class XmlValue(BaseValue):
    xml: Xml | None = None

    @root_validator(pre=True)
    def value_type_check(cls, values):
        keys = ["number", "blob", "blob"]
        if any(key in values for key in keys):
            raise TypeError(f"A xml value can not contain: {' '.join(keys)}")
        return values


Value = StringValue | NumberValue | BlobValue | XmlValue


class Device(BaseModel):
    name: str | None = None
    control_timeout: int | None = None
    control_when_offline: bool | None = None
    manufacturer: str | None = None
    product: str | None = None
    version: str | None = None
    serial: str | None = None
    description: str | None = None
    protocol: str | None = None
    communication: str | None = None
    included: str | None = None
    inclusion_status: InclusionStatus | None = None
    firmware_status: FirmwareStatus | None = None
    firmware_upload_progress: str | None = None
    firmware_available_version: str | None = None
    command: Command | None = None
    meta: DeviceMeta | None = Field(None, title='meta-2.0:create')
    status: list[Status | UUID4] | None = None
    value: list[Value | UUID4] | None = None
    info: Info | None = None

    # class Config:
    #     extra = Extra.forbid


class Network(BaseModel):
    name: str | None = None
    description: str | None = None
    device: list[Device | UUID4] | None = None
    meta: NetworkMeta | None = Field(None, title='meta-2.0:create')
    info: Info | None = None

    # class Config:
    #     extra = Extra.forbid


WappstoObject = Network | Device | Value | State
