# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:34:08+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Literal

from pydantic import BaseModel, Extra, Field, conint, constr


class Meta(BaseModel):
    class Config:
        extra = Extra.allow

    id: uuid.UUID | None = None
    trace: str | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None


class Actual(BaseModel):
    last_update: datetime.datetime | None = None
    point: int | None = None
    document: int | None = None
    log_row: int | None = None
    traffic_in: int | None = None
    traffic_out: int | None = None
    iot_traffic_in: int | None = None
    iot_traffic_out: int | None = None
    stream_traffic: int | None = None
    file: int | None = None
    request: int | None = None
    request_time: int | None = None
    sms: int | None = None


class UserDailyLimit(BaseModel):
    class Config:
        extra = Extra.forbid

    point: conint(ge=0) | Literal['dynamic'] | None = None
    document: conint(ge=0) | None = None
    log_row: conint(ge=0) | None = None
    traffic: conint(ge=0) | None = None
    iot_traffic: conint(ge=0) | None = None
    stream_traffic: conint(ge=0) | None = None
    file: conint(ge=0) | None = None
    request: conint(ge=0) | None = None
    request_time: conint(ge=0) | None = None
    sms: conint(ge=0) | None = None


class NetworkDailyLimit(BaseModel):
    class Config:
        extra = Extra.forbid

    point: conint(ge=0) | Literal['dynamic'] | None = None
    iot_traffic: conint(ge=0) | None = None
    request: conint(ge=0) | None = None
    request_time: conint(ge=0) | None = None


class Point(BaseModel):
    class Config:
        extra = Extra.allow

    meta: Meta | None = Field(None, title='meta-2.1')
    actual:  Actual | None = None
    user_daily_limit: UserDailyLimit | None = None
    network_daily_limit: NetworkDailyLimit | None = None
