# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:26:35+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Any, Literal

from pydantic import BaseModel, Extra, Field, constr


class Method(BaseModel):
    class Config:
        extra = Extra.forbid

    create: bool | None = None
    update: bool | None = None
    retrieve: bool | None = None
    delete: bool | None = None


class InstallationItem(BaseModel):
    class Config:
        extra = Extra.forbid

    create: list[str] | None = None
    method:  Method | None = None


class Application(BaseModel):
    class Config:
        extra = Extra.forbid

    sharing: bool | None = None
    permitted: list[uuid.UUID] | None = None


class Method1(BaseModel):
    create: bool | None = None
    update: bool | None = None
    retrieve: bool | None = None
    delete: bool | None = None


class State(BaseModel):
    class Config:
        extra = Extra.forbid

    min_state: float | None = None
    max_state: float | None = None


class Installation(BaseModel):
    class Config:
        extra = Extra.forbid

    shareable: bool | None = None


class File(BaseModel):
    background: bool | None = None


class AclAttribute(Enum):
    parent_name = 'parent_name'


class RestrictionItem(BaseModel):
    class Config:
        extra = Extra.forbid

    child: str | None = None
    create: list[str] | None = None
    application:  Application | None = None
    method:  Method1 | None = None
    time: dict[str, Any] | None = None
    state:  State | None = None
    installation:  Installation | None = None
    file:  File | None = None
    acl_attributes: list[AclAttribute] | None = None


class IdEnum(Enum):
    global_ = 'global'
    parent_owner = 'parent_owner'
    parent_manufacturer = 'parent_manufacturer'


class Assigned(Enum):
    unassigned = 'unassigned'
    admin = 'admin'


class WarningItem(BaseModel):
    message: str | None = None
    data: dict[str, Any] | None = None
    code: int | None = None


class Meta(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | constr(
        regex=r'(?:[a-zA-Z0-9!#$%&\'*+/=?^_`{|}~-]+(?:\.[a-zA-Z0-9!#$%&\'*+/=?^_`{|}~-]+)*|"(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21\x23-\x5b\x5d-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])*")@(?:(?:[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?\.)+[a-zA-Z0-9](?:[a-zA-Z0-9-]*[a-zA-Z0-9])?|\[(?:(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9]))\.){3}(?:(2(5[0-5]|[0-4][0-9])|1[0-9][0-9]|[1-9]?[0-9])|[a-zA-Z0-9-]*[a-zA-Z0-9]:(?:[\x01-\x08\x0b\x0c\x0e-\x1f\x21-\x5a\x53-\x7f]|\\[\x01-\x09\x0b\x0c\x0e-\x7f])+)\])'
    ) | IdEnum | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None


class PermissionItem(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str | None = None
    message: str | None = None
    temporary: bool | None = None
    expiration: datetime.datetime | None = None
    propagate: bool | None = None
    installation: list[InstallationItem] | None = None
    restriction: list[RestrictionItem]
    meta: Meta = Field(..., title='meta-2.1')


class Meta1(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None


class Acl(BaseModel):
    class Config:
        extra = Extra.forbid

    parent: dict[str, Any]
    owner: str | None = None
    manufacturer: uuid.UUID | None = None
    owner_name: str | None = None
    manufacturer_name: str | None = None
    shareable: bool
    permission: list[PermissionItem | str]
    meta: Meta1 = Field(..., title='meta-2.1')
