# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:26:58+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Any, Literal

from pydantic import BaseModel, Extra, Field, constr


class Assigned(Enum):
    unassigned = 'unassigned'
    admin = 'admin'


class WarningItem(BaseModel):
    message: str | None = None
    data: dict[str, Any] | None = None
    code: int | None = None


class Meta(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None


class Object(Enum):
    old = 'old'
    new = 'new'


class Type(Enum):
    array = 'array'
    hash = 'hash'
    number = 'number'
    string = 'string'
    boolean = 'boolean'
    generic = 'generic'


class ComponentItem(BaseModel):
    path: list[str | int]
    object:  Object | None = None
    type:  Type | None = None


class Succes(Enum):
    error = 'error'


class Example(BaseModel):
    class Config:
        extra = Extra.forbid

    old_data: Any | None = None
    new_data: Any
    last_update: datetime.datetime | None = None
    last_if_result: bool | None = None
    success: bool | Succes | None = None
    output: Any | None = None


class LastResult(BaseModel):
    timestamp: datetime.datetime | None = None
    success: bool | None = None
    output: Any | None = None


class TriggerOn(Enum):
    always = 'always'
    only_when_becomes_true = 'only_when_becomes_true'
    on_toggle = 'on_toggle'


class SendAs(Enum):
    email = 'email'
    notification = 'notification'


class Alert(BaseModel):
    class Config:
        extra = Extra.forbid

    meta: Meta = Field(..., title='meta-2.1')
    name: str | None = None
    enabled: bool
    component: list[ComponentItem]
    if_operation: list[str] | None = None
    then_operation: list[str] | None = None
    example:  Example | None = None
    last_result:  LastResult | None = None
    trigger_again_after: int | None = None
    trigger_on: TriggerOn
    parser_id: uuid.UUID | None = None
    send_as: SendAs
    subject: str | None = None
    subject_on_false: str | None = None
