# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:27:16+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Any, Literal

from pydantic import BaseModel, Extra, Field, conint, constr


class SupportedFeature(Enum):
    foreground = 'foreground'
    background = 'background'
    widget = 'widget'


class Description(BaseModel):
    class Config:
        extra = Extra.forbid

    general: str | None = None
    foreground: str | None = None
    background: str | None = None
    widget: str | None = None
    version: str | None = None


class PublishedVersion(BaseModel):
    class Config:
        extra = Extra.forbid

    version_app: str | None = None
    author: str | None = None
    session_user: bool | None = None
    native: bool | None = None
    uninstallable: bool | None = None
    max_number_installation: conint(ge=1) | None = None
    supported_features: list[SupportedFeature] | None = None
    description: Description | None = None


class Installed(BaseModel):
    last_update: datetime.datetime | None = None
    quantity: int | None = None


class Assigned(Enum):
    unassigned = 'unassigned'
    admin = 'admin'


class WarningItem(BaseModel):
    message: str | None = None
    data: dict[str, Any] | None = None
    code: int | None = None


class Meta(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None


class Engine(Enum):
    node = 'node'
    python = 'python'


class Executable(BaseModel):
    class Config:
        extra = Extra.forbid

    engine: Engine | None = None
    version: str | None = None


class Status(Enum):
    idle = 'idle'
    commit = 'commit'
    revision = 'revision'
    publish = 'publish'
    uncommit = 'uncommit'
    unpublish = 'unpublish'
    republish = 'republish'
    disable = 'disable'
    reenable = 'reenable'
    duplicate = 'duplicate'
    pending = 'pending'
    uncommitted = 'uncommitted'
    published = 'published'
    not_updated = 'not updated'
    unpublished = 'unpublished'
    disabled = 'disabled'


class Meta1(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None
    last_committed: uuid.UUID | None = None
    last_published: uuid.UUID | None = None


class Permission(BaseModel):
    create: list[str] | None = None
    permit_to_send_email: bool | None = None
    permit_to_send_sms: bool | None = None


class ConcernItem(BaseModel):
    class Config:
        extra = Extra.forbid

    concern: str
    line: conint(ge=0, multiple_of=1)


class ConcernFileItem(BaseModel):
    class Config:
        extra = Extra.forbid

    timestamp: datetime.datetime
    concern: list[ConcernItem] = Field(..., min_items=1)


class Meta2(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None


class FileItem(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str | None = None
    type: str | None = None
    size: conint(ge=0, multiple_of=1) | None = None
    published: bool | None = None
    concernFile: list[ConcernFileItem] | None = None
    meta: Meta2 = Field(..., title='meta-2.1')


class VersionItem(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str
    name_identifier: constr(regex=r'[0-9a-z_]') | None = None
    application: uuid.UUID | None = None
    author: str | None = None
    version_app: constr(regex=r'^(\d+\.\d+\.\d+)$') | None = None
    commit: str | None = None
    title: str | None = None
    session_user: bool | None = None
    concern: str | None = None
    native: bool | None = None
    name_folder: str | None = None
    icon: uuid.UUID | None = None
    priority: conint(ge=1, multiple_of=1) | None = None
    time_commit: datetime.datetime | None = None
    version_to_clone: uuid.UUID | None = None
    installation: list[uuid.UUID] | None = None
    uninstallable: bool | None = None
    published: bool | None = None
    executable: Executable | None = None
    max_number_installation: conint(ge=1, multiple_of=1) | None = None
    object_requested: dict[str, Any] | None = None
    supported_features: list[SupportedFeature] | None = None
    description: Description | None = None
    status: Status
    used_files: dict[str, Any]
    installed: Installed | None = None
    meta: Meta1 = Field(..., title='meta-2.1')
    permission: Permission | None = None
    file: list[FileItem | uuid.UUID] | None = None


class Meta3(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None


class ExternalItem(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str
    api_key: str
    api_secret_key: str
    api_site: str


class OauthClientItem(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str
    company: str | None = None
    description: str | None = None
    homepage_url: str | None = None
    expires: conint(ge=0) | None = None
    client_id: uuid.UUID
    client_secret: str | None = None
    redirect_uri: list[str] | None = None
    path_access_token: list[str] | None = None
    application_id: uuid.UUID
    installation_id: list[uuid.UUID]
    meta: Meta3 = Field(..., title='meta-2.1')
    external: list[ExternalItem] | None = None


class AccessTokenMethod(Enum):
    get = 'get'
    post = 'post'


class OauthVersion(Enum):
    field_1_0 = '1.0'
    field_1_0a = '1.0a'
    field_2_0 = '2.0'


class RefreshAccessTokenMethod(Enum):
    get = 'get'
    post = 'post'


class Meta4(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None


class OauthExternalItem(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str
    description: str | None = None
    api_callback: str | None = None
    api_key: str
    api_secret_key: str | None = None
    api_site: str
    api_extra_request: dict[str, Any] | None = None
    api_extra_request_required: list[str] | None = None
    api_extra_access_token: dict[str, Any] | None = None
    access_token_method:  AccessTokenMethod | None = None
    application_id: uuid.UUID | None = None
    oauth_version: OauthVersion
    oauth_request_token_url: str | None = None
    oauth_access_token_url: str | None = None
    oauth_refresh_access_token_url: str | None = None
    api_extra_refresh_access_token: dict[str, Any] | None = None
    refresh_access_token_method:  RefreshAccessTokenMethod | None = None
    meta: Meta4 = Field(..., title='meta-2.1')


class Meta5(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None


class Type(Enum):
    one_time = 'one_time'
    subscription = 'subscription'


class Interval(Enum):
    day = 'day'
    week = 'week'
    month = 'month'
    year = 'year'


class Recurring(BaseModel):
    class Config:
        extra = Extra.forbid

    interval: Interval
    interval_count: conint(ge=1)


class PricesWithTax(BaseModel):
    amount: int | None = None
    prepaid_extra_cost: int | None = None
    topup_extra_cost: int | None = None


class PricesWithoutTax(BaseModel):
    amount: int | None = None
    prepaid_extra_cost: int | None = None
    topup_extra_cost: int | None = None


class Tax(BaseModel):
    id: uuid.UUID | None = None
    prices_with_tax: PricesWithTax | None = None
    prices_without_tax: PricesWithoutTax | None = None
    name: str | None = None
    description: str | None = None
    jurisdiction: str | None = None
    inclusive: bool | None = None
    percentage: int | None = None
    state: str | None = None


class ApplicationProductItem(BaseModel):
    class Config:
        extra = Extra.forbid

    meta: Meta5 | None = Field(None, title='meta-2.1')
    name: str | None = None
    description: str | None = None
    active: bool | None = None
    deleted: bool | None = None
    stripe: dict[str, Any] | None = None
    type:  Type | None = None
    currency: str | None = None
    amount: conint(ge=1) | None = None
    recurring: Recurring | None = None
    tax: Tax | None = None
    trial_period_days: conint(ge=1) | None = None


class Application(BaseModel):
    class Config:
        extra = Extra.forbid

    last_published: uuid.UUID | None = None
    last_committed: uuid.UUID | None = None
    name: str
    installation: list[uuid.UUID] | None = None
    published_version:  PublishedVersion | None = None
    name_identifier: constr(regex=r'[0-9a-z_]') | None = None
    published: bool | None = None
    permit_free: bool | None = None
    installed: Installed | None = None
    meta: Meta = Field(..., title='meta-2.1')
    version: list[VersionItem | uuid.UUID]
    oauth_client: list[OauthClientItem | uuid.UUID] = Field(..., max_items=1)
    oauth_external: list[OauthExternalItem | uuid.UUID]
    application_product: list[ApplicationProductItem | uuid.UUID]
