# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:27:23+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Any, Literal

from pydantic import BaseModel, Extra, Field, conint, constr


class Assigned(Enum):
    unassigned = 'unassigned'
    admin = 'admin'


class WarningItem(BaseModel):
    message: str | None = None
    data: dict[str, Any] | None = None
    code: int | None = None


class Meta(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None


class Type(Enum):
    one_time = 'one_time'
    subscription = 'subscription'


class Interval(Enum):
    day = 'day'
    week = 'week'
    month = 'month'
    year = 'year'


class Recurring(BaseModel):
    class Config:
        extra = Extra.forbid

    interval: Interval
    interval_count: conint(ge=1)


class PricesWithTax(BaseModel):
    amount: int | None = None
    prepaid_extra_cost: int | None = None
    topup_extra_cost: int | None = None


class PricesWithoutTax(BaseModel):
    amount: int | None = None
    prepaid_extra_cost: int | None = None
    topup_extra_cost: int | None = None


class Tax(BaseModel):
    id: uuid.UUID | None = None
    prices_with_tax: PricesWithTax | None = None
    prices_without_tax: PricesWithoutTax | None = None
    name: str | None = None
    description: str | None = None
    jurisdiction: str | None = None
    inclusive: bool | None = None
    percentage: int | None = None
    state: str | None = None


class ApplicationProduct(BaseModel):
    class Config:
        extra = Extra.forbid

    meta: Meta | None = Field(None, title='meta-2.1')
    name: str | None = None
    description: str | None = None
    active: bool | None = None
    deleted: bool | None = None
    stripe: dict[str, Any] | None = None
    type:  Type | None = None
    currency: str | None = None
    amount: conint(ge=1) | None = None
    recurring: Recurring | None = None
    tax: Tax | None = None
    trial_period_days: conint(ge=1) | None = None
