# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:28:49+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Any, Literal

from pydantic import BaseModel, Extra, Field, confloat, constr


class Assigned(Enum):
    unassigned = 'unassigned'
    admin = 'admin'


class WarningItem(BaseModel):
    message: str | None = None
    data: dict[str, Any] | None = None
    code: int | None = None


class Meta(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None


class Recurrency(Enum):
    month = 'month'
    quarter = 'quarter'
    year = 'year'


class Language(Enum):
    en = 'en'
    dk = 'dk'


class Information(BaseModel):
    company: str | None = None
    street: str | None = None
    post_number: str | None = None
    city: str | None = None
    country: str | None = None
    tax_code: str | None = None
    tax_code_type: str | None = None
    email: str | None = None
    phone: str | None = None


class TheirReference(BaseModel):
    name: str | None = None
    email: str | None = None
    phone: str | None = None


class OurReference(BaseModel):
    name: str | None = None
    email: str | None = None
    phone: str | None = None


class Meta1(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None


class Recurrency1(Enum):
    one_time = 'one_time'
    subscription = 'subscription'


class Type(Enum):
    network = 'network'
    installation = 'installation'
    application = 'application'
    creator = 'creator'
    generic = 'generic'


class InvoiceItem(BaseModel):
    class Config:
        extra = Extra.forbid

    recurrency:  Recurrency1 | None = None
    type: Type
    filter: str | None = None
    filter_by_name: str | None = None
    filter_by_application: uuid.UUID | None = None
    quantity: int | None = None
    cost: int
    description: str
    dynamic: bool | None = None
    unit: str | None = None
    total: int | None = None


class CustomerInvoiceItem(BaseModel):
    class Config:
        extra = Extra.forbid

    meta: Meta1 | None = Field(None, title='meta-2.1')
    invoice_number: int | None = None
    name: str | None = None
    description: str | None = None
    paid: bool | None = None
    sent: bool | None = None
    overdue: bool | None = None
    total: int | None = None
    subtotal: int | None = None
    tax_total: int | None = None
    discount_total: int | None = None
    currency: str | None = None
    archived: bool | None = None
    due_days_after_sending_invoice: int | None = None
    create_automatic_next_invoice: bool | None = None
    due_timestamp: datetime.datetime | None = None
    paid_timestamp: datetime.datetime | None = None
    sent_timestamp: datetime.datetime | None = None
    due_payment_timestamp: datetime.datetime | None = None
    discount: confloat(ge=0.0, le=100.0) | None = None
    discount_before_tax: bool | None = None
    tax: confloat(ge=0.0, le=100.0) | None = None
    tax_included: bool | None = None
    note: list[str] | None = None
    invoice: list[InvoiceItem] | None = None


class Customer(BaseModel):
    class Config:
        extra = Extra.forbid

    meta: Meta | None = Field(None, title='meta-2.1')
    user_id: str
    seller: uuid.UUID | None = None
    currency: str | None = None
    due_days_after_sending_invoice: int | None = None
    discount_before_tax: bool | None = None
    tax_included: bool | None = None
    note: list[str] | None = None
    next_invoice: dict[str, Any] | None = None
    last_invoice: dict[str, Any] | None = None
    recurrency:  Recurrency | None = None
    create_automatic_next_invoice: bool | None = None
    archived: bool | None = None
    user_exists: bool | None = None
    language:  Language | None = None
    information:  Information | None = None
    their_reference:  TheirReference | None = None
    our_reference:  OurReference | None = None
    customer_number: int | None = None
    customer_invoice: list[CustomerInvoiceItem | uuid.UUID] | None = None
