# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:33:37+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Any, Literal

from pydantic import BaseModel, Extra, Field, constr


class AccessTokenMethod(Enum):
    get = 'get'
    post = 'post'


class OauthVersion(Enum):
    field_1_0 = '1.0'
    field_1_0a = '1.0a'
    field_2_0 = '2.0'


class RefreshAccessTokenMethod(Enum):
    get = 'get'
    post = 'post'


class Assigned(Enum):
    unassigned = 'unassigned'
    admin = 'admin'


class WarningItem(BaseModel):
    message: str | None = None
    data: dict[str, Any] | None = None
    code: int | None = None


class Meta(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None


class OauthExternal(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str
    description: str | None = None
    api_callback: str | None = None
    api_key: str
    api_secret_key: str | None = None
    api_site: str
    api_extra_request: dict[str, Any] | None = None
    api_extra_request_required: list[str] | None = None
    api_extra_access_token: dict[str, Any] | None = None
    access_token_method:  AccessTokenMethod | None = None
    application_id: uuid.UUID | None = None
    oauth_version: OauthVersion
    oauth_request_token_url: str | None = None
    oauth_access_token_url: str | None = None
    oauth_refresh_access_token_url: str | None = None
    api_extra_refresh_access_token: dict[str, Any] | None = None
    refresh_access_token_method:  RefreshAccessTokenMethod | None = None
    meta: Meta = Field(..., title='meta-2.1')
