# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:34:07+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Any, Literal

from pydantic import BaseModel, Extra, Field, conint, constr


class Assigned(Enum):
    unassigned = 'unassigned'
    admin = 'admin'


class WarningItem(BaseModel):
    message: str | None = None
    data: dict[str, Any] | None = None
    code: int | None = None


class Meta(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None


class Actual(BaseModel):
    last_update: datetime.datetime | None = None
    point: int | None = None
    document: int | None = None
    log_row: int | None = None
    traffic_in: int | None = None
    traffic_out: int | None = None
    iot_traffic_in: int | None = None
    iot_traffic_out: int | None = None
    stream_traffic: int | None = None
    file: int | None = None
    request: int | None = None
    request_time: int | None = None
    sms: int | None = None


class ActualNetwork(BaseModel):
    last_update: datetime.datetime | None = None
    manufactured_and_owned: int | None = None
    manufactured_not_owned: int | None = None
    owned_not_manufactured: int | None = None
    shared: int | None = None
    total: int | None = None


class CurrentPeriodEndEnum(Enum):
    never = 'never'


class UsageDaily(BaseModel):
    last_update: datetime.datetime | None = None
    point: int | None = None
    document: int | None = None
    log_row: int | None = None
    traffic: int | None = None
    iot_traffic: int | None = None
    stream_traffic: int | None = None
    file: int | None = None
    request: int | None = None
    request_time: int | None = None
    sms: int | None = None


class UserDailyLimit(BaseModel):
    class Config:
        extra = Extra.forbid

    point: conint(ge=0) | Literal['dynamic'] | None = None
    document: conint(ge=0) | None = None
    log_row: conint(ge=0) | None = None
    traffic: conint(ge=0) | None = None
    iot_traffic: conint(ge=0) | None = None
    stream_traffic: conint(ge=0) | None = None
    file: conint(ge=0) | None = None
    request: conint(ge=0) | None = None
    request_time: conint(ge=0) | None = None
    sms: conint(ge=0) | None = None


class NetworkDailyLimit(BaseModel):
    class Config:
        extra = Extra.forbid

    point: conint(ge=0) | Literal['dynamic'] | None = None
    iot_traffic: conint(ge=0) | None = None
    request: conint(ge=0) | None = None
    request_time: conint(ge=0) | None = None


class Point(BaseModel):
    class Config:
        extra = Extra.forbid

    meta: Meta = Field(..., title='meta-2.1')
    actual: Actual
    actual_network: ActualNetwork
    unlimited_period: bool
    unlimited_point: bool
    unlimited_network: bool
    unlimited_sms: bool | None = None
    base_point:  conint(ge=0) | Literal['unlimited']
    extra_point: conint(ge=0) | None = None
    base_sms: conint(ge=0) | Literal['unlimited'] | None = None
    extra_sms: conint(ge=0) | None = None
    base_network: conint(ge=0) | None = None
    current_period_start: datetime.datetime
    current_period_end: datetime.datetime | CurrentPeriodEndEnum
    remaining_point: int | None = None
    remaining_network: int | None = None
    remaining_sms: int | None = None
    remaining_percentage: float
    remaining_network_percentage: float
    remaining_sms_percentage: float | None = None
    are_still_point_available: bool
    are_still_network_available: bool
    are_still_sms_available: bool | None = None
    user_daily_limit: UserDailyLimit | None = None
    network_daily_limit: NetworkDailyLimit | None = None
    usage_daily: UsageDaily | None = None
