# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:37:09+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Any, Literal

from pydantic import BaseModel, Extra, Field, conint, constr


class Assigned(Enum):
    unassigned = 'unassigned'
    admin = 'admin'


class WarningItem(BaseModel):
    message: str | None = None
    data: dict[str, Any] | None = None
    code: int | None = None


class Meta(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None


class Type(Enum):
    private = 'private'
    public = 'public'
    enterprise = 'enterprise'


class Interval(Enum):
    day = 'day'
    week = 'week'
    month = 'month'
    year = 'year'
    never = 'never'


class RecurringPoint(BaseModel):
    class Config:
        extra = Extra.forbid

    interval: Interval
    interval_count: conint(ge=1)


class Meta1(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None


class Interval1(Enum):
    day = 'day'
    week = 'week'
    month = 'month'
    year = 'year'


class Recurring(BaseModel):
    class Config:
        extra = Extra.forbid

    interval: Interval1
    interval_count: conint(ge=1)


class PricesWithTax(BaseModel):
    amount: int | None = None
    prepaid_extra_cost: int | None = None
    topup_extra_cost: int | None = None


class PricesWithoutTax(BaseModel):
    amount: int | None = None
    prepaid_extra_cost: int | None = None
    topup_extra_cost: int | None = None


class Tax(BaseModel):
    id: uuid.UUID | None = None
    prices_with_tax: PricesWithTax | None = None
    prices_without_tax: PricesWithoutTax | None = None
    name: str | None = None
    description: str | None = None
    jurisdiction: str | None = None
    inclusive: bool | None = None
    percentage: int | None = None
    state: str | None = None


class PriceItem(BaseModel):
    class Config:
        extra = Extra.forbid

    meta: Meta1 = Field(..., title='meta-2.1')
    name: str | None = None
    unchangeable: bool | None = None
    stripe: dict[str, Any] | None = None
    active: bool
    free: bool
    currency: str | None = None
    amount: int | None = None
    prepaid_extra_cost: int | None = None
    topup_extra_cost: int | None = None
    recurring: Recurring | None = None
    tax: Tax | None = None


class Subscription(BaseModel):
    class Config:
        extra = Extra.forbid

    meta: Meta = Field(..., title='meta-2.1')
    stripe: dict[str, Any] | None = None
    unit_label: constr(min_length=2, max_length=12) | None = None
    description: str | None = None
    name: str
    active: bool | None = None
    deleted: bool | None = None
    free: bool
    change_immediately: bool | None = None
    images: list[str] | None = None
    type: Type
    user: list | None = None
    max_number_network: Literal['unlimited'] | conint(ge=0)
    extra_network: conint(ge=0) | None = None
    base_point: Literal['unlimited'] | conint(ge=0)
    prepaid_point: conint(ge=0) | None = None
    topup_point: conint(ge=0) | None = None
    base_sms: Literal['unlimited'] | conint(ge=0) | None = None
    prepaid_sms: conint(ge=0) | None = None
    topup_sms: conint(ge=0) | None = None
    recurring_point: RecurringPoint | None = None
    price: list[PriceItem | uuid.UUID] | None = None
