# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:37:14+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Any, Literal

from pydantic import BaseModel, Extra, Field, conint, constr


class Assigned(Enum):
    unassigned = 'unassigned'
    admin = 'admin'




class WarningItem(BaseModel):
    message: str | None = None
    data: dict[str, Any] | None = None
    code: int | None = None


class Meta(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None


class UserDailyLimit(BaseModel):
    class Config:
        extra = Extra.forbid

    point: conint(ge=0) | None = None
    document: conint(ge=0) | None = None
    log_row: conint(ge=0) | None = None
    traffic: conint(ge=0) | None = None
    iot_traffic: conint(ge=0) | None = None
    stream_traffic: conint(ge=0) | None = None
    file: conint(ge=0) | None = None
    request: conint(ge=0) | None = None
    request_time: conint(ge=0) | None = None


class NetworkDailyLimit(BaseModel):
    class Config:
        extra = Extra.forbid

    point: conint(ge=0) | None = None
    iot_traffic: conint(ge=0) | None = None
    request: conint(ge=0) | None = None
    request_time: conint(ge=0) | None = None


class DynamicLimitEnum(Enum):
    dynamic = 'dynamic'


class PointManagement(BaseModel):
    base_point:  conint(ge=0) | DynamicLimitEnum | None = None
    base_network:  conint(ge=0) | DynamicLimitEnum | None = None
    user_daily_limit: UserDailyLimit | None = None
    network_daily_limit: NetworkDailyLimit | None = None


class Subuser(BaseModel):
    class Config:
        extra = Extra.forbid

    first_name: str | None = None
    last_name: str | None = None
    email: constr(regex=r'^\S+@\S+\.\S+$') | None = None
    phone: str | None = None
    name: str | None = None
    role: str | None = None
    nickname: str | None = None
    language: str | None = None
    login_username: constr(regex=r'^\S+@\S+\.\S+$')
    session_token: uuid.UUID
    last_online: datetime.datetime | None = None
    meta: Meta = Field(..., title='meta-2.1')
    point_management: PointManagement | None = None
