# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:37:52+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Any, Literal

from pydantic import BaseModel, Extra, Field, conint, constr


class Engine(Enum):
    node = 'node'
    python = 'python'


class Executable(BaseModel):
    class Config:
        extra = Extra.forbid

    engine: Engine | None = None
    version: str | None = None


class SupportedFeature(Enum):
    foreground = 'foreground'
    background = 'background'
    widget = 'widget'


class Description(BaseModel):
    class Config:
        extra = Extra.forbid

    general: str | None = None
    foreground: str | None = None
    background: str | None = None
    widget: str | None = None
    version: str | None = None


class Status(Enum):
    idle = 'idle'
    commit = 'commit'
    revision = 'revision'
    publish = 'publish'
    uncommit = 'uncommit'
    unpublish = 'unpublish'
    republish = 'republish'
    disable = 'disable'
    reenable = 'reenable'
    duplicate = 'duplicate'
    pending = 'pending'
    uncommitted = 'uncommitted'
    published = 'published'
    not_updated = 'not updated'
    unpublished = 'unpublished'
    disabled = 'disabled'


class Installed(BaseModel):
    last_update: datetime.datetime | None = None
    quantity: int | None = None


class Assigned(Enum):
    unassigned = 'unassigned'
    admin = 'admin'




class WarningItem(BaseModel):
    message: str | None = None
    data: dict[str, Any] | None = None
    code: int | None = None


class Meta(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None
    last_committed: uuid.UUID | None = None
    last_published: uuid.UUID | None = None


class Permission(BaseModel):
    create: list[str] | None = None
    permit_to_send_email: bool | None = None
    permit_to_send_sms: bool | None = None


class ConcernItem(BaseModel):
    class Config:
        extra = Extra.forbid

    concern: str
    line: conint(ge=0, multiple_of=1)


class ConcernFileItem(BaseModel):
    class Config:
        extra = Extra.forbid

    timestamp: datetime.datetime
    concern: list[ConcernItem] = Field(..., min_items=1)


class Meta1(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None


class FileItem(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str | None = None
    type: str | None = None
    size: conint(ge=0, multiple_of=1) | None = None
    published: bool | None = None
    concernFile: list[ConcernFileItem] | None = None
    meta: Meta1 = Field(..., title='meta-2.1')


class Version(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str
    name_identifier: constr(regex=r'[0-9a-z_]') | None = None
    application: uuid.UUID | None = None
    author: str | None = None
    version_app: constr(regex=r'^(\d+\.\d+\.\d+)$') | None = None
    commit: str | None = None
    title: str | None = None
    session_user: bool | None = None
    concern: str | None = None
    native: bool | None = None
    name_folder: str | None = None
    icon: uuid.UUID | None = None
    priority: conint(ge=1, multiple_of=1) | None = None
    time_commit: datetime.datetime | None = None
    version_to_clone: uuid.UUID | None = None
    installation: list[uuid.UUID] | None = None
    uninstallable: bool | None = None
    published: bool | None = None
    executable: Executable | None = None
    max_number_installation: conint(ge=1, multiple_of=1) | None = None
    object_requested: dict[str, Any] | None = None
    supported_features: list[SupportedFeature] | None = None
    description: Description | None = None
    status: Status
    used_files: dict[str, Any]
    installed: Installed | None = None
    meta: Meta = Field(..., title='meta-2.1')
    permission: Permission | None = None
    file: list[FileItem | uuid.UUID] | None = None
