# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:37:57+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Any, Literal

from pydantic import BaseModel, Extra, Field, constr


class ProviderItem(BaseModel):
    class Config:
        extra = Extra.forbid

    name: str
    picture: str | None = None
    type: str


class PublicEnum(Enum):
    nickname = 'nickname'
    first_name = 'first_name'
    last_name = 'last_name'
    email = 'email'
    phone = 'phone'
    role = 'role'


class Status(Enum):
    pending = 'pending'
    refused = 'refused'
    accepted = 'accepted'
    send = 'send'
    not_sent = 'not_sent'
    archive = 'archive'


class OtherEmailItem(BaseModel):
    contact: constr(regex=r'^\S+@\S+\.\S+$') | None = None
    status: Status | None = None
    last_update: datetime.datetime | None = None


class OtherSm(BaseModel):
    contact: str | None = None
    status: Status | None = None
    last_update: datetime.datetime | None = None


class Type(Enum):
    soft = 'soft'
    strong = 'strong'


class Ban(BaseModel):
    type: Type
    begin_ban: datetime.datetime | None = None
    end_ban: datetime.datetime
    motivation: str


class Assigned(Enum):
    unassigned = 'unassigned'
    admin = 'admin'


class WarningItem(BaseModel):
    message: str | None = None
    data: dict[str, Any] | None = None
    code: int | None = None


class Meta(BaseModel):
    class Config:
        extra = Extra.forbid

    id: uuid.UUID | None = None
    type: str | None = None
    version: constr(regex=r'(\d+)\.(\d+)') | None = None
    manufacturer: uuid.UUID | Assigned | None = None
    owner: uuid.UUID | Assigned | None = None
    created: datetime.datetime | Literal['not_available'] | None = None
    updated: datetime.datetime | Literal['not_available'] | None = None
    changed: datetime.datetime | Literal['not_available'] | None = None
    application: uuid.UUID | None = None
    revision: int | None = None
    trace: str | None = None
    oem: str | None = None
    deprecated: bool | None = None
    redirect: constr(regex=r'^[0-9a-zA-Z_-]+$', min_length=1, max_length=200) | None = None
    size: int | None = None
    path: str | None = None
    parent: uuid.UUID | None = None
    error: dict[str, Any] | None = None
    icon: str | None = None
    tag: list[constr(min_length=2, max_length=20)] | None = None
    tag_by_user: list[constr(min_length=2, max_length=20)] | None = None
    name_by_user: constr(max_length=100) | None = None
    warning: list[WarningItem] | None = None
    parent_name: dict[str, Any] | None = None
    read_only: bool | None = None
    original_id: uuid.UUID | None = None
    alert: list[uuid.UUID] | None = None
    contract: list[uuid.UUID] | None = None


class Virtualuser(BaseModel):
    class Config:
        extra = Extra.forbid

    first_name: str | None = None
    last_name: str | None = None
    email: constr(regex=r'^\S+@\S+\.\S+$') | None = None
    phone: str | None = None
    name: str | None = None
    role: str | None = None
    nickname: str | None = None
    language: str | None = None
    provider: list[ProviderItem] | None = None
    public: list[PublicEnum] | None = None
    verified_email: bool | None = None
    verified_sms: bool | None = None
    other_email: list[OtherEmailItem] | None = None
    other_sms: list[OtherSm] | None = None
    admin: bool | None = None
    founder: bool | None = None
    installation: uuid.UUID | None = None
    subuser: bool | None = None
    subuser_owner: uuid.UUID | None = None
    last_online: datetime.datetime | None = None
    ban: Ban | None = None
    token: uuid.UUID | None = None
    special_token: uuid.UUID | None = None
    meta: Meta = Field(..., title='meta-2.1')
