# generated by datamodel-codegen:
#   filename:  <stdin>
#   timestamp: 2023-02-17T08:32:20+00:00

from __future__ import annotations

import uuid
import datetime
from enum import Enum
from typing import Literal

from pydantic import BaseModel, Extra, Field, confloat, conint, constr


class MethodEnum(Enum):
    retrieve = 'retrieve'
    update = 'update'
    add = 'add'
    delete = 'delete'


class Conjunction(Enum):
    and_ = 'and'
    or_ = 'or'


class WrongObject(Enum):
    expanded = 'expanded'
    compact = 'compact'
    hidden = 'hidden'


class Schema(Enum):
    create = 'create'
    update = 'update'
    output = 'output'
    query = 'query'


class AclAttribute(Enum):
    parent_name = 'parent_name'


class Order(Enum):
    ascending = 'ascending'
    descending = 'descending'


class TypeTimestamp(Enum):
    internal = 'internal'
    external = 'external'


class GroupBy(Enum):
    year = 'year'
    quarter = 'quarter'
    month = 'month'
    week = 'week'
    day = 'day'
    hour = 'hour'
    minute = 'minute'
    second = 'second'
    millisecond = 'millisecond'
    microsecond = 'microsecond'
    dow = 'dow'
    doy = 'doy'


class TimeAggregation(Enum):
    date_trunc = 'date_trunc'
    extract = 'extract'


class Operation(Enum):
    arbitrary = 'arbitrary'
    array_agg = 'array_agg'
    avg = 'avg'
    count = 'count'
    geometric_mean = 'geometric_mean'
    mean = 'mean'
    max = 'max'
    min = 'min'
    sqrdiff = 'sqrdiff'
    stddev = 'stddev'
    sum = 'sum'
    variance = 'variance'
    harmonic_mean = 'harmonic_mean'
    first = 'first'
    last = 'last'
    count_distinct = 'count_distinct'
    median = 'median'
    percentile = 'percentile'
    lower_quartile = 'lower_quartile'
    upper_quartile = 'upper_quartile'
    mode = 'mode'


class LogZip(BaseModel):
    class Config:
        extra = Extra.forbid

    id: list[uuid.UUID] | None = None
    offset: conint(ge=0, multiple_of=1) | None = None
    limit: conint(ge=0, multiple_of=1) | None = None
    manufacturer: bool | None = None
    owned: bool | None = None
    accepted: bool | None = None
    shared_with: list[uuid.UUID] | None = None
    not_shared_with: list[uuid.UUID] | None = None
    has_parent: bool | None = None
    version: list[constr(regex=r'\d+(\.\d+)*')] | None = None
    method: list[MethodEnum] | None = None
    deep: conint(ge=1, multiple_of=1) | None = None
    global_: bool | None = Field(None, alias='global')
    full_search: bool | None = None
    from_last: bool | None = None
    order_by: str | None = None
    permission_group: list[Literal['all'] | uuid.UUID] | None = None
    clean: bool | None = None
    conjunction:  Conjunction | None = None
    count: bool | None = None
    asynchronous: bool | uuid.UUID | None = None
    propagate: bool | None = None
    acl_code: uuid.UUID | None = None
    expand: conint(ge=0, multiple_of=1) | None = None
    quantity: int | Literal['all'] | None = None
    message: str | None = None
    opt_attr: list[str] | None = None
    opt_value: list[str] | None = None
    verbose: bool | list[str] | None = None
    compact: list[str] | None = None
    fetch: bool | None = None
    go_internal: bool | None = None
    expand_from_bottom: bool | None = None
    wrong_object:  WrongObject | None = None
    cache: conint(ge=1, le=86400) | None = None
    cache_refresh: bool | None = None
    csv_name: str | None = None
    csv_separator: str | None = None
    prev_notification: uuid.UUID | None = None
    schema_: Schema | None = Field(None, alias='schema')
    test_mode: bool | None = None
    acl_attributes: list[AclAttribute] | None = None
    start: datetime.datetime | None = None
    end: datetime.datetime | None = None
    column_separator: str | None = None
    decimal_separator: str | None = None
    timestamp_format: str | None = None
    timezone: str | None = None
    attribute: list[str] | None = None
    order:  Order | None = None
    type_timestamp:  TypeTimestamp | None = None
    group_by:  GroupBy | None = None
    time_aggregation:  TimeAggregation | None = None
    operation:  Operation | None = None
    percentile: confloat(ge=0.0, le=1.0) | None = None
    number: bool | None = None
